<?php

namespace App\Services;

use Webleit\ZohoBooksApi\Client;
use Weble\ZohoClient\Enums\Region;
use Webleit\ZohoBooksApi\Exceptions\ZohoBooksApiException;

class ZohoBooksService
{
    protected $client;

    public function __construct()
    {
        $oAuthClient = new \Weble\ZohoClient\OAuthClient(env('ZOHO_BOOKS_CLIENT_ID'), env('ZOHO_BOOKS_CLIENT_SECRET'));
        $oAuthClient->setRegion('eu'); // Change to Region::eu() for EU

        $this->client = new Client($oAuthClient);
    }

    public function getAuthUrl(): string
    {
        $this->client->getOAuthClient()->setRefreshToken(session('zoho_refresh_token'));
        return $this->client->getOAuthClient()->getAuthorizationUrl();
    }

    public function setRefreshToken(string $refreshToken): void
    {
        session(['zoho_refresh_token' => $refreshToken]);
    }

    public function createInvoice(array $invoiceData): array
    {
        $this->client->setOrganizationId(env('ZOHO_BOOKS_ORGANIZATION_ID'));

        try {
            $invoice = $this->client->invoice()->create($invoiceData);
            return $invoice->toArray();
        } catch (ZohoBooksApiException $e) {
            throw $e;
        }
    }
}
