<?php

namespace App\Services;

use App\Models\Styles;
use Illuminate\Support\Facades\DB;

class StyleService
{
    // In a later step, you can inject VersionService and ColourwayService here.

    /**
     * Save or update the style along with its nested data.
     *
     * @param  array  $data
     * @return \App\Models\Styles
     */
    public function saveStyle(array $data)
    {
        return DB::transaction(function () use ($data) {
            $style = Styles::updateOrCreate(
                ['id' => $data['id'] ?? null],
                [
                    'customers_id'       => $data['customers_id'],
                    'seasons_id'         => $data['seasons_id'],
                    'designs_id'         => $data['designs_id'],
                    'departments_id'     => $data['departments_id'],
                    'category'           => $data['category'],
                    'commodity_codes_id' => $data['commodity_codes_id'],
                    'customer_ref'       => $data['customer_ref'] ?? '',
                    'cancelled'          => $data['cancelled'] ?? false,
                    'carryover'          => $data['carryover'] ?? false,
                    'notes'              => $data['notes'] ?? '',
                    'intake_id'          => $data['intake_id'] ?? null,
                ]
            );

            // Future steps: Delegate processing of versions and colourways to their services.
            // For now, we simply return the style.

            return $style;
        });
    }
}
