<?php

namespace App\Services\PackingListImports\Extractors;

use App\Models\Customer;
use App\Services\PackingListImports\BaseExtractor;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class PurePackingListExtractor extends BaseExtractor
{
    public function extractData(TemporaryUploadedFile $file): array
    {
        return [
            'packing_lists' => [],
            'metadata' => [
                'filename' => $file->getClientOriginalName(),
                'extraction_method' => 'pure_packing_list',
            ],
        ];
    }

    public function getCustomerName(): string
    {
        return 'Pure Collection';
    }

    public function getCustomerId(): int
    {
        return (int) Customer::where('name', 'Pure Collection')->value('id');
    }

    public function validateCustomerData(array $data): array
    {
        return [];
    }
}


