<?php

namespace App\Services\PackingListImports\Extractors;

use App\Models\Customer;
use App\Services\PackingListImports\BaseExtractor;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class MrPorterPackingListExtractor extends BaseExtractor
{
    public function extractData(TemporaryUploadedFile $file): array
    {
        return [
            'packing_lists' => [],
            'metadata' => [
                'filename' => $file->getClientOriginalName(),
                'extraction_method' => 'mrporter_packing_list',
            ],
        ];
    }

    public function getCustomerName(): string
    {
        return 'Mr Porter';
    }

    public function getCustomerId(): int
    {
        return 250;
    }

    public function validateCustomerData(array $data): array
    {
        return [];
    }
}


