<?php

namespace App\Services\PackingListImports\Extractors;

use App\Models\Customer;
use App\Services\PackingListImports\BaseExtractor;
use Livewire\Features\SupportFileUploads\TemporaryUploadedFile;

class CharlesTyrwhittPackingListExtractor extends BaseExtractor
{
    public function extractData(TemporaryUploadedFile $file): array
    {
        return [
            'packing_lists' => [],
            'metadata' => [
                'filename' => $file->getClientOriginalName(),
                'extraction_method' => 'charles_tyrwhitt_packing_list',
            ],
        ];
    }

    public function getCustomerName(): string
    {
        return 'Charles Tyrwhitt';
    }

    public function getCustomerId(): int
    {
        return (int) Customer::where('name', 'Charles Tyrwhitt')->value('id');
    }

    public function validateCustomerData(array $data): array
    {
        return [];
    }
}


