<?php

namespace App\Providers;

use App\Models\Price;

use App\Models\Seasons;
use App\Facades\ZohoFacade;
use App\Models\ShipmentLines;
use App\Observers\SeasonsObserver;
use App\Services\ZohoService;
use App\Validation\CustomValidator;
use Asad\OAuth2\Client\Provider\Zoho;
use App\Models\ShipmentLineExftyDates;
use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Validator;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(ZohoService::class);
        // $this->app->singleton('zoho', function ($app) {
        //     return new ZohoService([
        //         'clientId' => env('ZOHO_CLIENT_ID'),
        //         'clientSecret' => env('ZOHO_CLIENT_SECRET'),
        //         'redirectUri' => route('zoho.callback'),
        //         'dc' => 'EU' // Adjust if needed
        //     ]);
        // });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot() {

        AliasLoader::getInstance()->alias('Zoho', ZohoFacade::class);

        Validator::extend('isNotEmpty', function ($attribute, $value, $parameters, $validator) {
            return !empty($value);
        });


        // Seasons::observe(SeasonsObserver::class);

        Builder::macro('whereRelationIn', function ($relation, $column, $array) {
            // dd($relation, $column, $array);
            return $this->whereHas(
                $relation, fn($q) => $q->whereIn($column, $array)
            );
        });

        Validator::extend('sanitized_string', function ($attribute, $value, $parameters, $validator) {
            $sanitizedValue = strip_tags($value);
            $sanitizedValue = preg_replace('/[^a-zA-Z0-9\s-]/', '', $sanitizedValue);

            // Set the sanitized value back into the validator
            $validator->addReplacer($attribute, function () use ($sanitizedValue) {
                return $sanitizedValue;
            });

            return true; // The sanitization is successful
        });



    }



    // ShipmentLineExftyDates::updating(function ($date) {
    //     $date->setAsRecent();
    // });
    // ShipmentLineExftyDates::creating(function ($date) {
    //     $date->setAsRecent();
    // });
}
