<?php

namespace App\Notifications;

use App\Models\CommissionOrder;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SkeletonOrderForwardedToPd extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CommissionOrder $order,
        public User $forwardedBy,
        public ?string $notes = null
    ) {}

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $url = route('commission.skeleton-orders') . '?status=pending_pd';
        
        $message = (new MailMessage)
            ->subject('Commission Order Awaiting Your Review - #' . $this->order->id)
            ->greeting('Hi ' . $notifiable->name . ',')
            ->line($this->forwardedBy->name . ' has forwarded a commission order for your review.')
            ->line('**Order Details:**')
            ->line('- Order ID: #' . $this->order->id)
            ->line('- Customer: ' . ($this->order->customer?->name ?? 'N/A'))
            ->line('- Customer PO: ' . ($this->order->customer_po ?? 'N/A'))
            ->line('- Season: ' . ($this->order->season?->description ?? 'N/A'));

        if ($this->notes) {
            $message->line('**Notes from ' . $this->forwardedBy->name . ':**')
                    ->line($this->notes);
        }

        return $message
            ->action('Review Order', $url)
            ->line('Please review the order and approve or make any necessary changes.');
    }
}

