<?php

namespace App\Notifications;

use App\Models\CommissionOrder;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SkeletonOrderApprovedByPd extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CommissionOrder $order,
        public User $approvedBy,
        public ?string $notes = null
    ) {}

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $url = route('commission.skeleton-orders') . '?status=pending_merch';
        
        $message = (new MailMessage)
            ->subject('Commission Order Approved by PD - #' . $this->order->id)
            ->greeting('Hi ' . $notifiable->name . ',')
            ->line($this->approvedBy->name . ' has approved the commission order and it\'s ready for your final confirmation.')
            ->line('**Order Details:**')
            ->line('- Order ID: #' . $this->order->id)
            ->line('- Customer: ' . ($this->order->customer?->name ?? 'N/A'))
            ->line('- Customer PO: ' . ($this->order->customer_po ?? 'N/A'))
            ->line('- Season: ' . ($this->order->season?->description ?? 'N/A'));

        if ($this->notes) {
            $message->line('**Notes from ' . $this->approvedBy->name . ':**')
                    ->line($this->notes);
        }

        return $message
            ->action('Review & Confirm Order', $url)
            ->line('Please review and confirm the order to make it a full order.');
    }
}

