<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;
class YarnOrderLineStyles extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;

    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];
    protected $fillable = [
        'yarn_order_lines_id',
        'notes',
        'created_at',
        'updated_at',
        'customer_order_lines_id',
        'invoice_no',
        'deleted_at',
    ];

    public function yarn_order_lines()
    {
        return $this->belongsTo(YarnOrderLine::class, 'yarn_order_lines_id', 'id');
    }
    public function customer_order_lines()
    {
        return $this->belongsTo(CustomerOrderLines::class);
    }
}
