<?php

namespace App\Models;

use App\Casts\Currency;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\BaseModel;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;
class YarnOrderLine extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;

    protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) { 
            $model->yarn_order_line_styles?->each?->delete();
        });
        static::restoring(function($model) { 
            $model->yarn_order_line_styles()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
        });
    }

    protected $casts = [
        'price' => Currency::class,
        'recd' => 'date:Y-m-d',
        'ship_date' => 'date:Y-m-d',
        'actual_ship_date' => 'date:Y-m-d',
        'delivery_date' => 'date:Y-m-d',
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

    protected $fillable = [
        'yarn_order_id',
        'price',
        'qty',
        'spinner_invoice_no',
        'factory_invoice_no',
        'recd',
        'ship_date',
        'actual_ship_date',
        'delivery_date',
        'notes',
        'created_at',
        'updated_at',
        'yarn_colours_id',
        'invoice_no',
        'invoiced_qty',
        'fn_notes',
        'deleted_at',
    ];


    public function yarn_orders()
    {
        return $this->belongsTo(YarnOrder::class, 'yarn_order_id');
    }
    public function yarn_colours()
    {
        return $this->belongsTo(YarnColours::class);
    }
    public function customer_order_lines()
    {
        return $this->belongsTo(CustomerOrderLines::class);
    }

    public function yarn_order_line_styles()
    {
        return $this->hasMany(YarnOrderLineStyles::class, 'yarn_order_lines_id', 'id');
    }
}
