<?php

namespace App\Models;

use App\Models\YarnOrder;
use Illuminate\Support\Facades\File;
use App\Models\BaseModel;
use Illuminate\Support\Facades\Storage;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class YarnOrderFiles extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;

    protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) {
            if($model->isForceDeleting()){
                if(File::exists('.'.Storage::url($model->file))){
                    File::delete('.'.Storage::url($model->file));
                }
            }
        });
    }
    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];
    protected $fillable = [
        'yarn_order_id',
        'file',
        'created_at',
        'updated_at',
        'filename',
        'deleted_at',
    ];

    public function yarn_orders()
    {
        return $this->belongsTo(YarnOrder::class);
    }
}
