<?php

namespace App\Models;

use App\Casts\Percentage;
use \Bkwld\Cloner\Cloneable;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class YarnComposition extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    use Cloneable;

    protected $casts = [
        'percentage' => Percentage::class,
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

	protected $fillable = [
        'yarn_id',
        'materials_id',
        'percentage',
        'created_at',
        'updated_at',
        'deleted_at',
    ];
	public function yarn()
    {
        return $this->belongsTo(Yarn::class);
    }
	public function materials()
    {
        return $this->belongsTo(Materials::class);
    }
}
