<?php

namespace App\Models;

use App\Casts\Upper;
use App\Casts\TitleCase;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class YarnColours extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    
    protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) { 
            $model->yarn_order_lines?->each?->delete();
            $model->colourway_yarns?->each?->delete();
        });
        static::restoring(function($model) { 
            $model->yarn_order_lines()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
            $model->colourway_yarns()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
        });
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('reference');
        });
    }
    protected static $orderByColumn = 'reference';

    protected $casts = [
        'reference' => Upper::class,
        'description' => TitleCase::class,
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];
    protected $fillable = [
        'yarn_id',
        'reference',
        'description',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

	public function yarn()
    {
        return $this->belongsTo(Yarn::class);
    }
    public function yarn_order_lines()
    {
        return $this->hasMany(YarnOrderLine::class);
    }
}
