<?php

namespace App\Models;

use App\Casts\Upper;
use App\Casts\TitleCase;
use Illuminate\Support\Str;
use App\Models\BaseModel;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ViewPrices extends BaseModel
{
    protected $casts = [
        'description' => TitleCase::class,
        'customer_ref' => Upper::class,
        'Style_version_name' => TitleCase::class,
        'factory' => TitleCase::class,
        'price_name' => TitleCase::class,
        'coo_ame' => TitleCase::class,
        'sizes_name' => Upper::class,
        'colourways_name' => TitleCase::class,
    ];


    protected $table = 'vw_prices';

    public function scopeSearch($query, $value){
		$query
		->where('description', 'like', "%{$value}%")
		->orwhere('design_id', 'like', "%{$value}%")
		->orwhere('customer_ref', 'like', "%{$value}%")
		->orwhere('factory', 'like', "%{$value}%")
		->orwhere('price_name', 'like', "%{$value}%")
		->orwhere('style_version_name', 'like', "%{$value}%")
		->orwhere('yarn', 'like', "%{$value}%")
		->orwhere('colourways', 'like', "%{$value}%")
		->orwhere('quote', 'like', "%{$value}%")
		->orwhere('cmt', 'like', "%{$value}%");
	}

}
