<?php

namespace App\Models;

use App\Casts\Upper;
use App\Casts\Boolean;
use App\Casts\TitleCase;
use App\Models\BaseModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ViewFinanceSamples extends BaseModel
{
    use HasFactory;

	
    protected $casts = [
        'approved_date' => 'date:Y-m-d',
        'date_expected' => 'date:Y-m-d',
        'date_sent' => 'date:Y-m-d',
        'date_received' => 'date:Y-m-d',
        'fn_complete' => Boolean::class,
        'description' => TitleCase::class,
        'colourway' => TitleCase::class,
        'size' => Upper::class,
        'po' => Upper::class,
    ];

    protected $table = 'vw_finance_samples';

    public function scopeSearch($query, $value){
		$query
		->where('description', 'like', "%{$value}%")
		->orwhere('customer_ref', 'like', "%{$value}%")
		->orwhere('factory', 'like', "%{$value}%")
		->orwhere('colourway', 'like', "%{$value}%");
	}
}
