<?php

namespace App\Models;

use App\Models\BaseModel;

class ViewCriticalPath extends BaseModel
{

    protected $table = 'vw_critical_path';

	protected $casts = [
        'revised_exfty' => 'date:Y-m-d',
        'origional_exfty' => 'date:Y-m-d',
	];

    public function scopeSearch($query, $value){
		$query
		->where('description', 'like', "%{$value}%")
		->orwhere('style', 'like', "%{$value}%")
		->orwhere('factory', 'like', "%{$value}%")
		->orwhere('colour', 'like', "%{$value}%");
	}
}
