<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class TotalCache extends Model
{
    protected $table = 'total_cache';

    protected $fillable = [
        'entity_type',
        'entity_id',
        'cache_key',
        'cached_data',
        'fresh_at',
    ];

    protected $casts = [
        'cached_data' => 'array',
        'fresh_at' => 'datetime',
    ];

    /**
     * Get the entity that owns the cache entry.
     */
    public function entity(): MorphTo
    {
        return $this->morphTo('entity', 'entity_type', 'entity_id');
    }

    /**
     * Scope for fresh cache entries.
     */
    public function scopeFresh($query)
    {
        return $query->whereNotNull('fresh_at');
    }

    /**
     * Scope for stale cache entries.
     */
    public function scopeStale($query)
    {
        return $query->whereNull('fresh_at');
    }

    /**
     * Scope for specific entity type.
     */
    public function scopeForEntityType($query, string $entityType)
    {
        return $query->where('entity_type', $entityType);
    }

    /**
     * Scope for specific entity.
     */
    public function scopeForEntity($query, string $entityType, int $entityId)
    {
        return $query->where('entity_type', $entityType)
                    ->where('entity_id', $entityId);
    }
}