<?php

namespace App\Models;

use App\Casts\Upper;
use App\Casts\Boolean;
use App\Casts\TitleCase;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SupplierAddress extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    protected $casts = [
        'name'  => TitleCase::class,
        'line1'  => TitleCase::class,
        'line2'  => TitleCase::class,
        'line3'  => TitleCase::class,
        'city'  => TitleCase::class,
        'region'  => TitleCase::class,
        'postcode'  => Upper::class,
        'carryover'  => Boolean::class,
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];
    protected $fillable = [
        'name',
        'suppliers_id',
        'line1',
        'line2',
        'line3',
        'city',
        'region',
        'postcode',
        'countries_id',
        'created_at',
        'updated_at',
        'email',
        'deleted_at',
    ];

    public function countries()
    {
        return $this->belongsTo(Countries::class);
    }

    public function suppliers()
    {
        return $this->hasMany(Suppliers::class);
    }
}
