<?php

namespace App\Models;

use App\Models\Suppliers;
use Bkwld\Cloner\Cloneable;
use Illuminate\Support\Facades\File;
use App\Models\BaseModel;
use Illuminate\Support\Facades\Storage;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ShipmentFiles extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use Cloneable;
protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) {
            Storage::delete($model->file);
        });
    }
    protected $casts = [
        'created_at'        => 'datetime:Y-m-d',
        'updated_at'        => 'datetime:Y-m-d',
        'deleted_at'        => 'datetime:Y-m-d',
    ];
	protected $fillable = [
        'shipment_id',
        'filename',
        'file',
        'type',
        'created_at',
        'updated_at',
        'deleted_at',
    ];
    public function transporters()
    {
        return $this->belongsTo(Suppliers::class);
    }
}
