<?php

namespace App\Models;

use App\Casts\Upper;
use App\Models\Sizes;
use App\Casts\Boolean;
use App\Models\BaseModel;
use App\Models\Colourways;
use App\Models\SampleTypes;
use \Bkwld\Cloner\Cloneable;
use App\Models\StyleVersions;
use Illuminate\Support\Facades\Cache;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Samples extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;

    protected static function booted(): void
    {
        parent::booted();
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('date_sent');
        });

        static::saved(function ($sample) {
            self::clearSampleCache($sample->colourways_id);
        });

        static::deleted(function ($sample) {
            self::clearSampleCache($sample->colourways_id);
        });
    }

    protected static function clearSampleCache($colourwaysId)
    {
        // Wipe all cache entries tied to this colourway
        \Log::info("Flushing sample cache for colourway", ['id' => $colourwaysId]);
        Cache::tags(["shipment_samples:colourway_{$colourwaysId}"])->flush();
    }

    protected $casts = [
        'po' => Upper::class,
        'tracking' => Upper::class,
        'approved_date' => 'date:Y-m-d',
        'fn_complete' => Boolean::class,
        'do_not_charge' => Boolean::class,
        'do_not_charge_dev' => Boolean::class,
        'date_expected' => 'date:Y-m-d',
        'date_sent' => 'date:Y-m-d',
        'date_received' => 'date:Y-m-d',
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

	protected $fillable = [
        'sample_types_id',
        'colourways_id',
        'date_expected',
        'date_sent',
        'tracking',
        'weight',
        'sizes_id',
        // 'yarn_ordered',
        // 'accessories_ordered',
        'date_received',
        // 'accepted',
        'do_not_charge',
        'comments',
        'qty',
        'rt_invoice',
        'fty_invoice',
        // 'last_updated_by',
        'created_at',
        'updated_at',
        'do_not_charge_dev',
        'finance_comments',
        'fn_notes',
        'po',
        'approved_date',
        'status',
        'production_comment',
        'fn_complete',
        'deleted_at',
    ];






    public function sizes()
    {
        return $this->belongsTo(Sizes::class);
    }
    public function sample_types()
    {
        return $this->belongsTo(SampleTypes::class);
    }
	public function style_versions()
    {
        return $this->belongsTo(StyleVersions::class);
    }
	public function colourways()
    {
        return $this->belongsTo(Colourways::class);
    }

    public function scopeSearch($query, $value)
    {
        // Split the search string into multiple terms
        $terms = preg_split('/\s+/', trim($value));

        $query->where(function($query) use ($terms) {
            foreach ($terms as $term) {
                // For each term, require at least one matching condition
                $query->where(function($q) use ($term) {
                    $q->whereRelation('colourways.style_versions.styles.designs', 'description', 'like', "%{$term}%")
                    ->orWhereRelation('colourways.style_versions.styles.designs', 'id', 'like', "%{$term}%")
                    ->orWhereRelation('colourways.style_versions.styles.customers', 'name', 'like', "%{$term}%")
                    ->orWhereRelation('colourways.style_versions.factories', 'name', 'like', "%{$term}%")
                    ->orWhereRelation('colourways.style_versions.styles', 'customer_ref', 'like', "%{$term}%")
                    ->orWhereRelation('colourways', 'name', 'like', "%{$term}%")
                    ->orWhereRelation('colourways.style_versions', 'name', 'like', "%{$term}%")
                    ->orWhere('rt_invoice', 'like', "%{$term}%");
                });
            }
        });
    }





    // public function charge(){
    //     if($this->do_not_charge)
    //         return '0.00';
    //     $sampleDiscount = $this->style_versions->styles->customers->setting('samples-charge');
    //     if(array_key_exists($this->sample_types_id, $sampleDiscount) && array_key_exists('discount', $sampleDiscount[$this->sample_types_id])){
    //         $sampleDiscount = $sampleDiscount[$this->sample_types_id]['discount'];
    //         if($sampleDiscount != FALSE && $sampleDiscount != "")
    //             return number_format((float)$this->style_versions->quote * (100 - $sampleDiscount)/100, 2, '.', '');
    //         else
    //             return $this->quote;
    //     }
    //     else
    //         return '0.00';
    // }

    // public function charge(){
    //     if($this->do_not_charge)
    //         return 'DNC';
    //     $sampleDiscount = $this->style_versions->styles->customers->setting('samples-charge');
    //     if(array_key_exists($this->sample_types_id, $sampleDiscount) && array_key_exists('discount', $sampleDiscount[$this->sample_types_id])){
    //         $sampleDiscount = $sampleDiscount[$this->sample_types_id]['discount'];
    //             return $sampleDiscount;
    //     }
    //     else
    //         return '0';
    // }

    // public function surcharge(){
    //     if($this->do_not_charge)
    //         return 'DNC';
    //     $sampleSurcharge = $this->style_versions->styles->customers->setting('samples-charge');
    //     if(array_key_exists($this->sample_types_id, $sampleSurcharge) && array_key_exists('surcharge', $sampleSurcharge[$this->sample_types_id])){
    //         $sampleSurcharge = $sampleSurcharge[$this->sample_types_id]['surcharge'];
    //             return $sampleSurcharge;
    //     }
    //     else
    //         return '0';
    // }
    // public function development(){
    //     // dd($this->style_versions->styles);
    //     if($this->do_not_charge || $this->do_not_charge_dev || $this->style_versions->styles->carryover)
    //         return 'DNC';
    //     $sampleDevelopment = $this->style_versions->styles->customers->setting('samples-charge');
    //     if(array_key_exists($this->sample_types_id, $sampleDevelopment) && array_key_exists('development', $sampleDevelopment[$this->sample_types_id])){
    //         $sampleDevelopment = $sampleDevelopment[$this->sample_types_id]['development'];
    //             return $sampleDevelopment;
    //     }
    //     else
    //         return '0';
    // }
    // public function chargeFreight(){
    //     if($this->do_not_charge)
    //         return FALSE;
    //     $freight = $this->style_versions->styles->customers->setting('samples-charge');
    //     if(array_key_exists($this->sample_types_id, $freight) && array_key_exists('freight', $freight[$this->sample_types_id])){
    //         $freight = $freight[$this->sample_types_id]['freight'];
    //         if($freight != FALSE && $freight == TRUE)
    //             return TRUE;
    //         else
    //             return FALSE;
    //     }
    //     else
    //         return FALSE;
    // }
}
