<?php

namespace App\Models;

use App\Casts\TitleCase;
use \Bkwld\Cloner\Cloneable;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SampleTypes extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    use Cloneable;

    protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) { 
            $model->samples?->each?->delete();
        });
        static::restoring(function($model) { 
            $model->samples()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
        });
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('name');
        });
    }

    
    
    protected $casts = [
        "name" => TitleCase::class,
        "charge" => "boolean",
        "charge_proto" => "boolean",
        "charge_surcharge" => "boolean",
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

	protected $fillable = [
        'name',
        'charge',
        'charge_proto',
        'charge_surcharge',
        'created_at',
        'updated_at',
        'deleted_at',
        
    ];

	public function samples()
    {
        return $this->hasMany(Samples::class);
    }

    public function scopeSearch($query, $value){
		$query->where('name', 'like', "%{$value}%");
	} 
}
