<?php

namespace App\Models;

use App\Models\BaseModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InvoiceLayout extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;

    protected $casts = [
        'default' => 'boolean',
        'line_vat' => 'boolean',
        'per_size' => 'boolean',
        'separate_invoice_per_collection_date' => 'boolean',
    ];

	protected $fillable = [
        'name',
        'line_title',
        'line_description',
        'line_price',
        'line_qty',
        'line_vat',
        'invoice_comments',
        'invoice_by',
        'invoice_layout',
        'per_size',
        'default',
        'separate_invoice_per_collection_date',
    ];

    public function customer_invoice_layouts()
    {
        return $this->hasMany(CustomerInvoiceLayout::class);
    }

}
