<?php

namespace App\Models;

use App\Casts\TitleCase;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Intake extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    // use SoftDeletes;
    use HasFactory;

    protected $casts = [
        'description' => TitleCase::class,
        'start' => 'datetime:Y-m-d',
        'end' => 'datetime:Y-m-d',
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

    protected $fillable = [
        'description',
        'start',
        'end',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function styles()
    {
        return $this->hasMany(Styles::class);
    }
}
