<?php

namespace App\Models;

use App\Models\BaseModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerPaymentTerm extends BaseModel
{
    use HasFactory;

    // Table name, if you prefer to explicitly define it
    protected $table = 'customer_payment_terms';

    // Specify fillable fields for mass assignment
    protected $fillable = [
        'customer_id',
        'percentage',
        'days',
    ];

    /**
     * Define a relationship back to the Customer model.
     */
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
