<?php

namespace App\Models;

use Bkwld\Cloner\Cloneable;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Models\BaseModel;
use Illuminate\Support\Facades\Storage;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerOrderFiles extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    use Cloneable;

    protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) {
            if($model->isForceDeleting()){
                if(File::exists('.'.Storage::url($model->file))){
                    File::delete('.'.Storage::url($model->file));
                }
            }
        });
    }

    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

    protected $fillable = [
        'customer_orders_id',
        'filename',
        'file',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function customer_orders()
    {
        return $this->belongsTo(CustomerOrders::class);
    }
}
