<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerInvoiceLayout extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'invoice_layouts_id',
        'incoterm',
    ];

    public function invoice_layouts()
    {
        return $this->belongsTo(InvoiceLayout::class, 'invoice_layouts_id');
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
