<?php

namespace App\Models;

use App\Casts\TitleCase;
use Illuminate\Support\Str;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerAgents extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;


    protected static function booted(): void
    {
        parent::booted();
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('name');
        });
    }

    protected $casts = [
        'name' => TitleCase::class,
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

    protected $fillable = [
        'created_at',
        'updated_at',
        'name',
        'email',
        'phone',
        'customers_id',
        'deleted_at',
    ];

    // protected function Name(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }


    public function customers()
    {
        return $this->belongsTo(Customer::class);
    }
}
