<?php

namespace App\Models;

use App\Casts\Upper;
use App\Casts\TitleCase;
use Illuminate\Support\Str;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomerAddress extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    protected $casts = [
        'postcode' => Upper::class,
        'name' => TitleCase::class,
        'line1' => TitleCase::class,
        'line2' => TitleCase::class,
        'line3' => TitleCase::class,
        'city' => TitleCase::class,
        'region' => TitleCase::class,
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];

    protected $fillable = [
        'name',
        'customer_id',
        'line1',
        'line2',
        'line3',
        'city',
        'region',
        'postcode',
        'countries_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];
    
    // protected function Name(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }
    // protected function Line1(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }
    // protected function Line2(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }
    // protected function Line3(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }
    // protected function City(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }
    // protected function Region(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::title($value),
    //     );
    // }
    // protected function Postcode(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::upper($value),
    //     );
    // }

    public function countries()
    {
        return $this->belongsTo(Countries::class);
    }

    public function customer_orders()
    {
        return $this->hasOne(CustomerOrders::class, 'id', 'customer_addresses_id');
    }

    public function customers()
    {
        return $this->hasMany(Customer::class);
    }

}
