<?php

namespace App\Models;

use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CommodityCodes extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    protected static function booted(): void
    {
        parent::booted();
        static::deleting(function($model) {
            $model->styles?->each?->delete();
        });
        static::restoring(function($model) {
            $model->styles()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
        });
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('order')->orderBy('description');
        });
    }

    protected $casts = [
        'created_at' => 'datetime:Y-m-d',
        'updated_at' => 'datetime:Y-m-d',
        'deleted_at' => 'datetime:Y-m-d',
    ];
	protected $fillable = [
        'order',
        'description',
        'Gender',
        'Type',
        'Composition',
        'created_at',
        'updated_at',
        'deleted_at',
    ];
    public function styles()
    {
        return $this->hasMany(Styles::class);
    }

    public function scopeSearch($query, $value){
        $query->where('id', 'like', "%{$value}%")->orWhere(function ($query) use ($value) {
            $words = explode(' ', $value);
            foreach($words as $word){
                $query->where('description', 'like', "%{$word}%")->orWhere('id', $value);
            }
        });
	}
}
