<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CommissionOrderWorkflowHistory extends Model
{
    protected $table = 'commission_order_workflow_history';

    protected $fillable = [
        'commission_orders_id',
        'action',
        'from_status',
        'to_status',
        'from_user_id',
        'to_user_id',
        'notes',
    ];

    public function order(): BelongsTo
    {
        return $this->belongsTo(CommissionOrder::class, 'commission_orders_id');
    }

    public function fromUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'from_user_id');
    }

    public function toUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'to_user_id');
    }

    /**
     * Get a human-readable description of the action
     */
    public function getActionLabelAttribute(): string
    {
        return match($this->action) {
            'forward_to_pd' => 'Forwarded to PD',
            'pd_approved' => 'PD Approved',
            'merch_approved' => 'Merch Confirmed',
            'sent_back_to_pd' => 'Sent back to PD',
            default => ucfirst(str_replace('_', ' ', $this->action)),
        };
    }
}


