<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Contracts\Auditable;

class CommissionOrderLineQuantity extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;

    protected $table = 'commission_order_line_quantities';

    protected $casts = [
        'qty' => 'integer',
        'price' => 'decimal:2',
        'discount' => 'decimal:2',
        'commission' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected $fillable = [
        'commission_order_lines_id',
        'sizes_id',
        'qty',
        'price',
        'discount',
        'commission',
    ];

    // ==================
    // Relationships
    // ==================

    public function line()
    {
        return $this->belongsTo(CommissionOrderLine::class, 'commission_order_lines_id');
    }

    public function size()
    {
        return $this->belongsTo(Sizes::class, 'sizes_id');
    }

    // ==================
    // Accessors
    // ==================

    public function getLineValueAttribute()
    {
        return $this->qty * ($this->price ?? 0);
    }

    public function getDiscountValueAttribute()
    {
        if (!$this->discount || !$this->price) {
            return 0;
        }
        return $this->qty * $this->price * ($this->discount / 100);
    }

    public function getCommissionValueAttribute()
    {
        if (!$this->commission || !$this->price) {
            return 0;
        }
        return $this->qty * $this->price * ($this->commission / 100);
    }

    public function getNetValueAttribute()
    {
        return $this->lineValue - $this->discountValue;
    }
}


