<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use OwenIt\Auditing\Contracts\Auditable;

class CommissionDropSize extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;

    protected $table = 'commission_drop_sizes';

    protected $casts = [
        'qty' => 'decimal:2',
        'shipped_qty' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    protected $fillable = [
        'commission_drops_id',
        'sizes_id',
        'qty',
        'shipped_qty',
    ];

    // ==================
    // Relationships
    // ==================

    public function drop()
    {
        return $this->belongsTo(CommissionDrop::class, 'commission_drops_id');
    }

    public function size()
    {
        return $this->belongsTo(Sizes::class, 'sizes_id');
    }

    // ==================
    // Accessors
    // ==================

    public function getEffectiveQtyAttribute()
    {
        return $this->shipped_qty ?: $this->qty;
    }

    /**
     * Get the price for this size from the order line quantities
     */
    public function getPriceAttribute()
    {
        return $this->drop?->line?->quantities
            ->where('sizes_id', $this->sizes_id)
            ->first()
            ?->price ?? 0;
    }

    public function getLineValueAttribute()
    {
        return $this->effectiveQty * $this->price;
    }
}

























