<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\BaseModel;
use \Bkwld\Cloner\Cloneable;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Colourway Accessory model
 * 
 * Represents the relationship between colourways and accessories.
 * 
 * @deprecated This class will be removed after upgrade
 */
class ColourwayAccessories extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use Cloneable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'colourways_id',
        'accessories_id',
        'price',
        'colour',
        'qty',
        'not_full_factored'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'price' => 'decimal:2',
        'qty' => 'integer',
        'not_full_factored' => 'boolean',
    ];

    /**
     * Get the colourway for this colourway accessory.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function colourways()
    {
        return $this->belongsTo(Colourways::class);
    }

    /**
     * Get the accessory for this colourway accessory.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function accessories()
    {
        return $this->belongsTo(Accessories::class);
    }

    /**
     * Get the accessory colour for this colourway accessory.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function accessory_colours()
    {
        return $this->belongsTo(AccessoryColours::class);
    }
}