<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\BaseModel;

/**
 * Cashflow model
 * 
 * Represents cashflow data in the system.
 */
class Cashflow extends BaseModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'data',
        'locked',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data' => 'array',
        'locked' => 'boolean',
    ];

    /**
     * Get the cashflow lines for this cashflow.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function cashflow_lines()
    {
        return $this->hasMany(CashflowLine::class, 'cashflows_id');
    }
}
