<?php

namespace App\Mail;

use App\Models\Customer;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class NewCustomerCreated extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(
        public Customer $customer,
        public string $createdBy
    ) {}

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'New Customer Created: ' . $this->customer->name,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        // Use config app.url to build the link (works in queued jobs)
        $baseUrl = config('app.url', 'https://knit.roberttodds.com');
        $customerUrl = $baseUrl . '/customers/' . $this->customer->id;
        
        return new Content(
            view: 'mail.new-customer-created',
            with: [
                'customer' => $this->customer,
                'createdBy' => $this->createdBy,
                'customerUrl' => $customerUrl,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}

