<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\CommissionInvoiceGroup;

class CommissionInvoiceReady extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(
        public CommissionInvoiceGroup $invoice,
        public string $senderName
    ) {}

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $customerName = $this->invoice->customer?->name ?? 'Unknown';
        $reference = $this->invoice->reference ?? "#{$this->invoice->id}";
        
        return new Envelope(
            subject: "Commission Invoice Ready: {$customerName} - {$reference}",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'mail.commission-invoice-ready',
            with: [
                'invoice' => $this->invoice,
                'senderName' => $this->senderName,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}



