<?php

namespace App\Livewire\Forms;

use App\Models\StyleVersions;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Attributes\Rule;
use Livewire\Form;

class StyleEditVersionsForm extends Form
{
	// public ?Collection $styleVersion;

    public function rules() 
    {
        return [
			'styleVersions'                => 'required',
			'styleVersions.*.name'         => 'required|string|max:35',
			'styleVersions.*.factory_id'   => 'required|numeric|min:1',
			'styleVersions.*.gauge_id'     => 'required|numeric|min:1',
			'styleVersions.*.no_yarn_ends' => 'nullable|numeric|min:1|max:1000',
			'styleVersions.*.issued'       => 'nullable|date',
        ];
    }

	public $styleVersions;

	public function clear(){
		$this->reset();
		$this->factory_id = "";
		$this->gauges_id = "";
	}

	public function new($style){
		$this->clear();
		$this->styles_id = $style;
	}

	public function set($svs)
	{
		foreach($svs as $s=>$sv){
			$this->styleVersions[$s] = [
				'styleVersion' => $sv,
				'name'         => $sv->name,
				'factory_id'   => $sv->factory_id,
				'gauge_id'     => $sv->gauge_id,
				'yarn_ends'    => $sv->yarn_ends,
				'issued'       => $sv->issued,
			];
		}
		// $this->styleVersion = $svs;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		foreach($this->styleVersions as $sv){
			if(empty($sv['styleVersion'])){
				StyleVersions::create(array_slice($sv, 1));
			}
			else{
				$sv['styleVersion']->update(
					array_slice($sv, 1)
				);
			}
		}
		session()->flash('message', 'Version Information Saved');
		session()->flash('alert-class', 'alert-success');
	}
}
