<?php

namespace App\Livewire\Forms;

use Livewire\Wireable;

class StyleEditNewForm implements Wireable
{
    public array $styleEdit = [];

    /**
     * Initialize a new (blank) style structure.
     */
    public function new(): void
    {
        $this->styleEdit = [
            'customers_id'        => null,
            'seasons_id'          => null,
            'designs_id'          => null,
            'departments_id'      => null,
            'category'            => null,
            'commodity_codes_id'  => null,
            'customer_ref'        => null,
            'cancelled'           => false,
            'carryover'           => false,
            'notes'               => null,
            'intake_id'           => null,
            'style_versions'      => [
                [
                    'factory_id'  => null,
                    'name'        => '',
                    'gauge_id'    => null,
                    'yarn_ends'   => null,
                    'issued'      => null,
                    'colourways'  => [
                        [
                            'name'              => '',
                            'comments'          => null,
                            'cancelled'         => false,
                            'accessories'       => null,
                            'colour_type'       => '',
                            'image'             => null,
                            'img_thumb'         => null,
                            'new_image'         => null,
                            'colourway_yarns'   => [
                                [
                                    'suppliers_id'    => null,
                                    'yarn_id'         => null,
                                    'yarn_colours_id' => null,
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    /**
     * Set the form data from an existing style.
     *
     * @param \App\Models\Styles $style
     */
    public function set($style): void
    {
        // Convert the model to an array.
        // You may need to massage the data structure here.
        $this->styleEdit = $style->toArray();
    }

    /**
     * Return data for Livewire serialization.
     */
    public function toLivewire()
    {
        return $this->styleEdit;
    }

    /**
     * Recreate an instance of the class from Livewire data.
     *
     * @param mixed $value
     * @return static
     */
    public static function fromLivewire($value)
    {
        $instance = new static();
        $instance->styleEdit = $value;
        return $instance;
    }
}
