<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Design;
use App\Models\Styles;
use App\Models\Colourways;
use App\Models\StyleVersions;
use Livewire\Attributes\Rule;
use App\Models\ColourwayYarns;
use Illuminate\Support\Facades\Gate;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;

class StyleEditForm extends Form
{
	public $styleOrigional;
	public $styleEdit;

    public $images;
	public $commodity_codes_id;

	public function rules()
    {
        return [
			'styleEdit.customers_id' => 'required|integer|min:1',
			'styleEdit.seasons_id' => 'required|integer|min:1',
			'styleEdit.designs_id' => 'required|integer|min:1',
			'styleEdit.departments_id' => 'required|integer|min:1',
			'styleEdit.category' => 'required|in:ladies,mens,childrens,accessories',
			'styleEdit.commodity_codes_id' => 'nullable|integer|min:1',
			'styleEdit.customer_ref' => 'nullable|string|max:35',
			'styleEdit.cancelled' => 'nullable|boolean',
			'styleEdit.carryover' => 'nullable|boolean',
			'styleEdit.notes' => 'nullable|string|max:5000',
			'styleEdit.intake_id' => 'nullable|exists:intakes,id',

			'styleEdit.style_versions.*.styles_id' => 'nullable|integer|min:1',
			'styleEdit.style_versions.*.factory_id' => 'required|integer|min:1',
			'styleEdit.style_versions.*.name' => 'required|string|max:35',
			'styleEdit.style_versions.*.gauge_id' => 'required|integer|min:1',
			'styleEdit.style_versions.*.yarn_ends' => 'nullable|numeric',
			'styleEdit.style_versions.*.issued' => 'nullable|date',

            'styleEdit.style_versions.*.sample_yarn' => 'nullable|in:Not Ordered,Expected,Arrived',
            'styleEdit.style_versions.*.sample_yarn_date' => 'nullable|date',
            'styleEdit.style_versions.*.sample_accessories' => 'nullable|in:Not Ordered,Expected,Arrived',
            'styleEdit.style_versions.*.sample_accessories_date' => 'nullable|date',

			'styleEdit.style_versions.*.colourways.*.style_versions_id' => 'nullable|integer|min:1',
			'styleEdit.style_versions.*.colourways.*.name' => 'required|string|max:35',
			'styleEdit.style_versions.*.colourways.*.comments' => 'nullable|string|max:3000',
			'styleEdit.style_versions.*.colourways.*.cancelled' => 'nullable|boolean',
			'styleEdit.style_versions.*.colourways.*.accessories' => 'nullable|string|max:3000',
			'styleEdit.style_versions.*.colourways.*.colour_type' => 'required|in:solid,melange,mixed',
			'styleEdit.style_versions.*.colourways.*.image' => 'nullable|string|max:150',
			'styleEdit.style_versions.*.colourways.*.img_thumb' => 'nullable|string|max:150',
			'styleEdit.style_versions.*.colourways.*.new_image' => 'nullable|image|max:20000',
			'styleEdit.style_versions.*.colourways.*.customer_description' => 'nullable|string|max:35',

			'styleEdit.style_versions.*.colourways.*.colourway_yarns.*.colourways_id' => 'nullable|integer|min:1',
			'styleEdit.style_versions.*.colourways.*.colourway_yarns.*.cust_ref' => 'nullable|string|max:35',
			'styleEdit.style_versions.*.colourways.*.colourway_yarns.*.percentage' => 'nullable|numeric',
			'styleEdit.style_versions.*.colourways.*.colourway_yarns.*.price' => 'nullable|numeric',
			'styleEdit.style_versions.*.colourways.*.colourway_yarns.*.not_full_factored' => 'nullable|boolean',
			'styleEdit.style_versions.*.colourways.*.colourway_yarns.*.yarn_colours_id' => 'required|integer|min:1',

            // 'images.*' => 'image|max:20000',
		];
	}






	public function clear(){
		$this->reset();
		$this->departments_id = "";
		$this->seasons_id = "";
		$this->customers_id = "";
		$this->category = "";
		$this->commodity_codes_id = "";
		$this->intake_id = "";
	}

    public function new()
    {
        $this->styleEdit = [
            'customers_id' => null,
            'seasons_id' => null,
            'designs_id' => null,
            'departments_id' => null,
            'category' => null,
            'commodity_codes_id' => null,
            'customer_ref' => null,
            'cancelled' => false,
            'carryover' => false,
            'notes' => null,
            'intake_id' => null,
            'style_versions' => [
                [
                    'factory_id' => null,
                    'gauge_id' => null,
                    'name' => '',
                    'colourways' => [
                        [
                            'name' => '',
                            'customer_description' => '',
                            'comments' => null,
                            'cancelled' => false,
                            'accessories' => null,
                            'colour_type' => '',
                            'image' => null,
                            'img_thumb' => null,
                            'new_image' => null,
                            'colourway_yarns' => [
                                [
                                    'suppliers_id' => null,
                                    'yarn_id' => null,
                                    'yarn_colours_id' => null,
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

	public function set($style)
	{
        $this->clear();
		$this->styleOrigional = $style;
		$this->styleEdit = $this->styleOrigional->toArray();


		foreach($this->styleEdit['style_versions'] as $sv=>$style_version){
			foreach($style_version['colourways'] as $c=>$colourway){
				foreach($colourway['colourway_yarns'] as $cy=>$colourway_yarn){
					$this->styleEdit['style_versions'][$sv]['colourways'][$c]['colourway_yarns'][$cy]['suppliers_id'] = $colourway_yarn['yarn_colours']['yarn']['suppliers_id'];
					$this->styleEdit['style_versions'][$sv]['colourways'][$c]['colourway_yarns'][$cy]['yarn_id'] = $colourway_yarn['yarn_colours']['yarn']['id'];

				}
			}
		}
	}

    public function setNestedValue($path, $value) {
        // dd($this);
        data_set($this->styleEdit, $path, $value);
        // dd($this->styleEdit, $path, $value);
    }

	public function update()
	{
        // if(Gate::check('admin'))
        //     dd($this->styleEdit);
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		$styleSaved = Styles::updateOrCreate(
			[
				'id' => $this->styleEdit['id'] ?? "",
			],
			[
				'customers_id' => $this->styleEdit['customers_id'],
				'seasons_id' => $this->styleEdit['seasons_id'],
				'designs_id' => $this->styleEdit['designs_id'],
				'departments_id' => $this->styleEdit['departments_id'],
				'category' => $this->styleEdit['category'],
				'commodity_codes_id' => $this->styleEdit['commodity_codes_id'],
				'customer_ref' => $this->styleEdit['customer_ref'] ?? "",
				'cancelled' => $this->styleEdit['cancelled'],
				'carryover' => $this->styleEdit['carryover'],
				'notes' => $this->styleEdit['notes'] ?? "",
				'intake_id' => $this->styleEdit['intake_id'] ?? null,
			]
		);

        $styleSaved->designs->update(['description' => $this->styleEdit['designs']['description']]);

		$svIds = collect($this->styleEdit['style_versions'] ?? [])->pluck('id')->toArray();
		foreach($styleSaved->load('style_versions')->style_versions as $DBsv){
			if(!in_array($DBsv->id, $svIds)){
                try{
				    $DBsv->delete();
                } catch (\Exception $e) {
                    session()->flash('message', $e->getMessage());
                    session()->flash('alert-class', 'alert-danger');
                    return;
                }
			}
		}
		foreach($this->styleEdit['style_versions'] as $sv=>$style_version){
			$styleVersionSaved = StyleVersions::updateOrCreate(
				[
					'id' => $style_version['id'] ?? ""
				],
				[
					"styles_id" => $styleSaved->id,
					"factory_id" => $style_version['factory_id'],
					"name" => $style_version['name'],
					"gauge_id" => $style_version['gauge_id'],
					"yarn_ends" => $style_version['yarn_ends'] ?? 0,
					"issued" => $style_version['issued'] ?? NULL,

                    "sample_yarn" => $style_version['sample_yarn'] ?? 'Not Ordered',
                    "sample_yarn_date" => $style_version['sample_yarn_date'] ?? NULL,
                    "sample_accessories" => $style_version['sample_accessories'] ?? 'Not Ordered',
                    "sample_accessories_date" => $style_version['sample_accessories_date'] ?? NULL,
				]
			);
			// dd($styleVersionSaved);

            $cIds = collect($style_version['colourways'] ?? [])->pluck('id')->toArray();
            foreach($styleVersionSaved->load('colourways')->colourways as $DBc){
                if(!in_array($DBc->id, $cIds)){
                    try{
                        $DBc->delete();
                    } catch (\Exception $e) {
                        session()->flash('message', $e->getMessage());
                        session()->flash('alert-class', 'alert-danger');
                        return;
                    }
                }
            }

			foreach($style_version['colourways'] ?? [] as $c=>$colourway){

				$colourwaySaved = Colourways::updateOrCreate(
					[
						'id' => $colourway['id'] ?? ""
					],
					[
						"style_versions_id" => $styleVersionSaved->id,
						"name" => $colourway['name'],
						"customer_description" => $colourway['customer_description'],
						"comments" => $colourway['comments'] ?? "",
						"cancelled" => $colourway['cancelled'],
						"accessories" => $colourway['accessories'] ?? "",
						"colour_type" => $colourway['colour_type'],
					]
				);

                if(!empty($colourway['new_image'])){

					$img = Image::make($colourway['new_image'])->resize(1000, 1000, function ($constraint) {
						$constraint->aspectRatio();
						$constraint->upsize();
					})->encode('jpg',80);
					$thumb = Image::make($colourway['new_image'])->resize(200, 200, function ($constraint) {
						$constraint->aspectRatio();
						$constraint->upsize();
					})->encode('jpg',50);
					if(!empty($colourway['image']))
						Storage::delete('storage/' . $colourway['image']);
					if(!empty($colourway['img_thumb']))
						Storage::delete('storage/' . $colourway['img_thumb']);



					$hash = md5($img->__toString());

					$paththumb = "images/{$hash}-thumb.jpg";
					if(Storage::disk('public')->put($paththumb, $thumb)){
						$colourwaySaved->update(['img_thumb' => $paththumb]);
					}

					$path = "images/{$hash}.jpg";
					if(Storage::disk('public')->put($path, $img)){
                        $colourwaySaved->update(['image' => $path]);
					}
                    // dd($path, $colourwaySaved->image);

				}

				$cyarnIds = collect($colourway['colourway_yarns'] ?? [])->pluck('id')->toArray();
				foreach($colourwaySaved->load('colourway_yarns')->colourway_yarns as $DBcy){
					if(!in_array($DBcy->id, $cyarnIds)){
						$DBcy->delete();
					}
				}
				foreach($colourway['colourway_yarns'] ?? [] as $cy=>$colourway_yarn){
					$colourwayYarn = ColourwayYarns::updateOrCreate(
						[
							'id' => $colourway_yarn['id'] ?? ""
						],
						[
							"colourways_id" => $colourwaySaved->id,
							"cust_ref" => $colourway_yarn['cust_ref'] ?? "",
							"percentage" => $colourway_yarn['percentage'] ?? "",
							"price" => $colourway_yarn['price'] ?? "",
							"not_full_factored" => $colourway_yarn['not_full_factored'] ?? "",
							"yarn_colours_id" => $colourway_yarn['yarn_colours_id'],
						]
					);
				}



			}

		}

        $this->reset('images');

		session()->flash('message', 'Style Information Saved');
		session()->flash('alert-class', 'alert-success');
	}

	public function getYarnSuppliers(){
		$suppliers = [];
		foreach($this->styleEdit['style_versions'] as $sv){
			foreach($sv['colourways'] ?? [] as $cw){
				foreach($cw['colourway_yarns'] ?? [] as $yarn){
					$suppliers[] = $yarn['suppliers_id'] ?? "";
				}
			}
		}
		return collect($suppliers)->unique();
	}

	public function getYarns(){
		$yarns = [];
		foreach($this->styleEdit['style_versions'] as $sv){
			foreach($sv['colourways'] ?? [] as $cw){
				foreach($cw['colourway_yarns'] ?? [] as $yarn){
					$yarns[] = $yarn['yarn_id'] ?? "";
				}
			}
		}
		return collect($yarns)->unique();
	}

    public function cloneVersion($v){
        $version = $this->styleEdit['style_versions'][$v];
        unset($version['id']);
        foreach($version['colourways'] as $c=>$colourway){
            unset($version['colourways'][$c]['id']);
            foreach($colourway['colourway_yarns'] as $cwy=>$cwYarn){
                unset($version['colourways'][$c]['colourway_yarns'][$cwy]['id']);
            }
        }
        $version['name'] = $version['name'] . '(B)';
        $this->styleEdit['style_versions'][] = $version;
    }

    public function addVersion()
    {
        $this->styleEdit['style_versions'][] = [
            'factory_id' => null,
            'name' => '',
            'gauge_id' => null,
            'yarn_ends' => null,
            'issued' => null,
            'sample_yarn' => 'Not Ordered',
            'sample_yarn_date' => null,
            'sample_accessories' => 'Not Ordered',
            'sample_accessories_date' => null,
            'colourways' => [],
        ];
    }

    public function addColourway($v)
    {
        $this->styleEdit['style_versions'][$v]['colourways'][] = [
            'name' => '',
            'comments' => null,
            'cancelled' => false,
            'accessories' => null,
            'colour_type' => '',
            'image' => null,
            'img_thumb' => null,
            'new_image' => null,
            'colourway_yarns' => [],
        ];
    }

    public function addYarn($v, $c)
    {
        $this->styleEdit['style_versions'][$v]['colourways'][$c]['colourway_yarns'][] = ['suppliers_id' => NULL, 'yarn_id' => NULL, 'yarn_colours_id' => NULL];
    }

}
