<?php

namespace App\Livewire\Forms;

use App\Models\StyleVersions;
use Livewire\Form;
use App\Models\Design;
use App\Models\Styles;
use Livewire\Attributes\Rule;

class StyleEditDetailsForm extends Form
{
	public ?Styles $style;

	#[Rule('integer|min:1', as: 'Design')]
	public $designs_id;

	public $styles_id;

	#[Rule('integer|min:1', as: 'Department')]
	public $departments_id;

	#[Rule('integer|min:1', as: 'Season')]
	public $seasons_id;

	#[Rule('integer|min:1', as: 'Customer')]
	public $customers_id;

	#[Rule('nullable|string|max:35', as: 'Description')]
	public $description;

	#[Rule('nullable|string|max:35', as: 'Category')]
	public $category;

	#[Rule('integer|min:1', as: 'Commodity Code')]
	public $commodity_codes_id;

	#[Rule('nullable|string|max:35', as: 'Customer Reference')]
	public $customer_ref;

	#[Rule('boolean', as: 'Cancelled')]
	public $cancelled;

	#[Rule('boolean', as: 'Carryover')]
	public $carryover;

	#[Rule('nullable|string|max:5000', as: 'Notes')]
	public $notes;
	
	
	#[Rule('nullable|integer|min:1', as: 'Gauge')]
	public $gauge_id;

	#[Rule('nullable|integer|min:1', as: 'Factory')]
	public $factory_id;


	// public $commodity_codes_search;



	public function clear(){
		$this->reset();
		$this->departments_id = "";
		$this->seasons_id = "";
		$this->customers_id = "";
		$this->category = "";
		$this->commodity_codes_id = "";
	}

	public function new(){
		$this->clear();
		$this->cancelled = 0;
		$this->carryover = 0;
	}

	public function set(Styles $style)
	{
		$this->style              = $style;
		$this->designs_id         = $style->designs_id;
		$this->departments_id     = $style->departments_id;
		$this->seasons_id         = $style->seasons_id;
		$this->customers_id       = $style->customers_id;
		$this->description        = $style->designs?->description;
		$this->category           = $style->category;
		$this->commodity_codes_id = $style->commodity_codes_id;
		$this->customer_ref       = $style->customer_ref;
		$this->cancelled          = $style->cancelled;
		$this->carryover          = $style->carryover;
		$this->notes              = $style->notes;
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
		if(empty($this->style)){
			$style           = Styles::create($this->only(['customers_id', 'seasons_id', 'designs_id', 'departments_id', 'seasons_id', 'category', 'commodity_codes_id', 'customer_ref', 'cancelled', 'carryover', 'notes']));
			$this->styles_id = $style->id;
			$sv              = new StyleVersions;
			$sv->factory_id  = $this->factory_id;
			$sv->gauge_id    = $this->gauge_id;
			$sv->name        = "A";
			$sv->styles_id   = $this->styles_id;
			$sv->save();
		}
		else{
			$this->style->update(
				$this->only(['designs_id', 'departments_id', 'seasons_id', 'category', 'commodity_codes_id', 'customer_ref', 'cancelled', 'carryover', 'notes'])
			);
		}
		if($this->style ?? 0)
			$this->style->designs->update($this->only(['description']));
		else
			$style->designs->update($this->only(['description']));
		session()->flash('message', 'Style Information Saved');
		session()->flash('alert-class', 'alert-success');
	}

}
