<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Colourways;
use Livewire\Attributes\Rule;
use App\Models\ColourwayYarns;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;

class StyleEditColourwaysForm extends Form
{
    public $delete = [];

    public function rules()
    {
        return [
			'colourways'                             => 'required',
			'colourways.*.id'                        => 'nullable|numeric|min:1',
			'colourways.*.style_versions_id'         => 'required|numeric|min:1',
			'colourways.*.name'                      => 'required|string|max:35',
			'colourways.*.comments'                  => 'nullable|string|max:5000',
			'colourways.*.cancelled'                 => 'required|boolean',
			'colourways.*.colour_type'               => 'required|in:solid,melange,mixed',
			'colourways.*.accessories'               => 'nullable|string|max:5000',
			'colourways.*.yarns.*.id'                => 'nullable|numeric|min:1',
			'colourways.*.yarns.*.colourways_id'     => 'required|numeric|min:1',
			'colourways.*.yarns.*.cust_ref'          => 'required|string|max:35',
			'colourways.*.yarns.*.percentage'        => 'required|numeric|min:0|max:100',
			'colourways.*.yarns.*.price'             => 'required|numeric|min:0|max:1000',
			'colourways.*.yarns.*.not_full_factored' => 'required|boolean',
			'colourways.*.yarns.*.yarn_colours_id'   => 'required|numeric|min:1',
			'images.*'                               => 'image',
        ];
    }


	public $colourways;
	public $colourwaysOrigional;

	public $images;

	public function clear(){
		$this->reset();
		$this->factory_id = "";
		$this->gauges_id = "";
	}

	public function new($style){
		$this->clear();
		$this->styles_id = $style;
	}

	public function set($colourways)
	{
		$this->colourwaysOrigional = $colourways;
		foreach($colourways as $c=>$colourway){
			$this->colourways[$c] = [
				'id'                => $colourway->id,
				'style_versions_id' => $colourway->style_versions_id,
				'name'              => $colourway->name,
				'image'             => $colourway->image,
				'comments'          => $colourway->comments,
				'cancelled'         => $colourway->cancelled,
				'colour_type'       => $colourway->colour_type,
				'img_thumb'         => $colourway->img_thumb,
				'accessories'       => $colourway->accessories,
			];
			foreach($colourway->colourway_yarns as $cy=>$colourway_yarn){
				$this->colourways[$c]['yarns'][$cy] = [
					'id'                => $colourway_yarn->id,
					'colourways_id'     => $colourway_yarn->colourways_id,
					'cust_ref'          => $colourway_yarn->cust_ref,
					'percentage'        => $colourway_yarn->percentage,
					'price'             => $colourway_yarn->price,
					'not_full_factored' => $colourway_yarn->not_full_factored,
					'yarn_colours_id'   => $colourway_yarn->yarn_colours_id,
					'yarn_id'           => $colourway_yarn->yarn_colours->yarn_id,
					'suppliers_id'      => $colourway_yarn->yarn_colours->yarn->suppliers_id,
				];
			}
		}
	}

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

        foreach($this->delete as $colourway){
            if(!empty($this->colourwaysOrigional->find($colourway))){
                $this->colourwaysOrigional->find($colourway)->delete();
            }
        }

		foreach($this->colourways ?? [] as $c=>$colourway){
			if(!empty($this->images[$c])){
				$img = Image::make($this->images[$c])->resize(1000, 1000, function ($constraint) {
					$constraint->aspectRatio();
					$constraint->upsize();
				})->encode('jpg',80);
				$thumb = Image::make($this->images[$c])->resize(200, 200, function ($constraint) {
					$constraint->aspectRatio();
					$constraint->upsize();
				})->encode('jpg',50);
				Storage::delete('storage/' . $colourway['image']);
				Storage::delete('storage/' . $colourway['img_thumb']);

				$hash = md5($img->__toString());
				$path = "images/{$hash}.jpg";



				if(Storage::disk('public')->put($path, $img))
					$colourway['image'] = $path;

				$path = "images/{$hash}-thumb.jpg";
				if(Storage::disk('public')->put($path, $thumb))
					$colourway['img_thumb'] = $path;
			}
			$colourway_yarns = [];
			foreach($colourway['yarns'] ?? [] as $y=>$yarn){
				$col_yarn = new ColourwayYarns;
				$col_yarn->cust_ref = $yarn['cust_ref'] ?? "";
				$col_yarn->percentage = $yarn['percentage'] ?? NULL;
				$col_yarn->price = $yarn['price'] ?? NULL;
				$col_yarn->not_full_factored = $yarn['not_full_factored'] ?? FALSE;
				$col_yarn->yarn_colours_id = $yarn['yarn_colours_id'];

				$colourway_yarns[] = $col_yarn;
			}

			if(empty($colourway['id'])){
				$newColourway = Colourways::create([
					'style_versions_id' => $colourway['style_versions_id'],
					'name' => $colourway['name'],
					'comments' => $colourway['comments'] ?? "",
					'cancelled' => $colourway['cancelled'],
					'colour_type' => $colourway['colour_type'],
					'image' => $colourway['image'] ?? "",
					'img_thumb' => $colourway['img_thumb'] ?? "",
					'accessories' => $colourway['accessories'] ?? "",
				]);
				$newColourway->colourway_yarns()->saveMany($colourway_yarns);
			}
			else{
				$this->colourwaysOrigional[$c]->update([
					'style_versions_id' => $colourway['style_versions_id'],
					'name' => $colourway['name'],
					'comments' => $colourway['comments'] ?? "",
					'cancelled' => $colourway['cancelled'],
					'colour_type' => $colourway['colour_type'],
					'image' => $colourway['image'] ?? "",
					'img_thumb' => $colourway['img_thumb'] ?? "",
					'accessories' => $colourway['accessories'] ?? "",
				]);
				$this->colourwaysOrigional[$c]->colourway_yarns()->delete();
				$this->colourwaysOrigional[$c]->colourway_yarns()->saveMany($colourway_yarns);
			}
		}
		// dd($colourway);
		session()->flash('message', 'Colourway Information Saved');
		session()->flash('alert-class', 'alert-success');
	}

	public function getYarnSuppliers(){
		$suppliers = [];
		foreach($this->colourways as $cw){
			foreach($cw['yarns'] ?? [] as $yarn){
				$suppliers[] = $yarn['suppliers_id'] ?? "";
			}
		}
		return collect($suppliers)->unique();
	}

	public function getYarns(){
		$yarns = [];
		foreach($this->colourways as $cw){
			foreach($cw['yarns'] ?? [] as $yarn){
				$yarns[] = $yarn['yarn_id'] ?? "";
			}
		}
		return collect($yarns)->unique();
	}
}
