<?php

namespace App\Livewire\Forms;

use App\Models\ShipmentFiles;
use App\Models\ShipmentLine;
use Livewire\Form;
use App\Models\Shipment;
use App\Models\YarnOrder;
use App\Models\YarnOrderLine;
use App\Models\YarnOrderFiles;
use App\Models\YarnOrderLineStyles;
use Illuminate\Support\Facades\Storage;

class ShipmentEditForm extends Form
{
	public ?Shipment $shipment;

	public $shipmentEdit = [], $uploadFiles = [];

	public function rules()
    {
        return [
			'shipmentEdit.transporter_id'   => 'required|numeric|min:1',
			'shipmentEdit.organiser'   => 'required|string:max:35',
			'shipmentEdit.cost'   => 'required|numeric|max:10000',
			'shipmentEdit.additional_cost'   => 'nullable|numeric|min:0',
			'shipmentEdit.customs_submitted'   => 'required|boolean',
			'shipmentEdit.customs_submitted_text'   => 'nullable|string:max:35',
			'shipmentEdit.comments'   => 'nullable|string|max:1000',
			'shipmentEdit.no_cartons'   => 'nullable|numeric|min:1|max:1000',
			'shipmentEdit.weight'   => 'nullable|numeric|min:0.01|max:10000',
			'shipmentEdit.no_trucks'   => 'nullable|numeric|min:1|max:100',

			'uploadFiles.*.*'   => 'nullable|file',

			'shipmentEdit.shipment_lines.*.truck_plates'   => 'nullable|string|max:10',
			'shipmentEdit.shipment_lines.*.collection_date'   => 'nullable|date',
			'shipmentEdit.shipment_lines.*.delivery_date'   => 'nullable|date',
			'shipmentEdit.shipment_lines.*.complete'   => 'required|boolean',
			'shipmentEdit.shipment_lines.*.rt_invoice'   => 'nullable|string|max:35',
			'shipmentEdit.shipment_lines.*.factory_invoice'   => 'nullable|string|max:35',
			'shipmentEdit.shipment_lines.*.customs_agency_invoice'   => 'nullable|string|max:35',
        ];
    }


	public function clear(){
		$this->reset();
		$this->gauge_id = "";
		$this->factory_id = "";
		$this->customers_id = "";
	}

	public function set(Shipment $shipment)
	{
		$this->shipment = $shipment;
		$this->shipmentEdit = $shipment->toArray();
	}

	public function new(){
		$this->shipmentEdit = [
			'customs_submitted' => FALSE,
		];
	}

	public function update()
	{
		$success = TRUE;
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();

        // dd($this->uploadFiles);



		$shipment = Shipment::updateOrCreate(
			['id' => $this->shipmentEdit['id'] ?? 0],
			['transporter_id'         => $this->shipmentEdit['transporter_id'] ?? NULL,
			'organiser'              => $this->shipmentEdit['organiser'] ?? NULL,
			'cost'                   => $this->shipmentEdit['cost'] ?? NULL,
			'additional_cost'        => $this->shipmentEdit['additional_cost'] ?? NULL,
			'customs_submitted'      => $this->shipmentEdit['customs_submitted'] ?? NULL,
			'customs_submitted_text' => $this->shipmentEdit['customs_submitted_text'] ?? NULL,
			'comments'               => $this->shipmentEdit['comments'] ?? NULL,
			'no_cartons'             => $this->shipmentEdit['no_cartons'] ?? NULL,
			'weight'                 => $this->shipmentEdit['weight'] ?? NULL,
			'no_trucks'              => $this->shipmentEdit['no_trucks'] ?? NULL,]
		);


		foreach($this->shipmentEdit['shipment_lines'] ?? [] as $l=>$line){
			ShipmentLine::updateOrCreate(
				['id' => $line['id'] ?? 0],
				['truck_plates'           => $line['truck_plates'] ?? NULL,
				'collection_date'        => $line['collection_date'] ?? NULL,
				'delivery_date'          => $line['delivery_date'] ?? NULL,
				'complete'               => $line['complete'] ?? NULL,
				'rt_invoice'             => $line['rt_invoice'] ?? NULL,
				'factory_invoice'        => $line['factory_invoice'] ?? NULL,
				'customs_agency_invoice' => $line['customs_agency_invoice'] ?? NULL,]
			);
		}

        if($this->uploadFiles != []){
            foreach($this->uploadFiles as $type=>$files){
                foreach($files as $file){
                    $path = NULL;
                    $entry = new ShipmentFiles();
                    $path = Storage::disk('public')->put('shipmentFiles', $file);
                    if($path != NULL){
                        $entry->shipment_id = $shipment->id;
                        $entry->filename = $file->getClientOriginalName();
                        $entry->type = $type;
                        $entry->file = $path;
                        $entry->save();
                    }
                }
            }
        }

		return $success;
	}
}
