<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Samples;
use Livewire\Attributes\Rule;

class SamplesEditBulkForm extends Form
{
	#[Rule('nullable|boolean', as: 'Sample Type Check')]
	public $sample_types_id_update;
	#[Rule('nullable|numeric|min:1', as: 'Sample Type')]
	public $sample_types_id;
	#[Rule('nullable|boolean', as: 'Received Check')]
	public $date_expected_update = FALSE;

	#[Rule('nullable|date', as: 'Received')]
	public $date_expected;

	#[Rule('nullable|boolean', as: 'Sent Check')]
	public $date_sent_update = FALSE;

	#[Rule('nullable|date', as: 'Sent')]
	public $date_sent;

	#[Rule('nullable|boolean', as: 'Tracking Check')]
	public $tracking_update = FALSE;

	#[Rule('nullable|string|max:35', as: 'Tracking')]
	public $tracking;

	#[Rule('nullable|boolean', as: 'Weight Check')]
	public $weight_update = FALSE;

	#[Rule('nullable|numeric|min:0|max:1000', as: 'Weight')]
	public $weight;

	#[Rule('nullable|boolean', as: 'Size Check')]
	public $sizes_id_update = FALSE;

	#[Rule('nullable|numeric|min:1', as: 'Size')]
	public $sizes_id;

	#[Rule('nullable|boolean', as: 'Qty Check')]
	public $qty_update = FALSE;

	#[Rule('nullable|numeric|min:1', as: 'Qty')]
	public $qty;

	#[Rule('nullable|boolean', as: 'Status Check')]
	public $status_update = FALSE;

	#[Rule('nullable|in:pending,approved,rejected', as: 'Status')]
	public $status;

	#[Rule('nullable|boolean', as: 'Comments Check')]
	public $comments_update = FALSE;

	#[Rule('nullable|string|max:5000', as: 'Comments')]
	public $comments;

	#[Rule('nullable|boolean', as: 'Charge Check')]
	public $do_not_charge_update = FALSE;

	#[Rule('nullable|nullable|boolean', as: 'Charge')]
	public $do_not_charge;

	#[Rule('nullable|boolean', as: 'Charge Dev Check')]
	public $do_not_charge_dev_update = FALSE;

	#[Rule('nullable|nullable|boolean', as: 'Charge Dev')]
	public $do_not_charge_dev;

	#[Rule('nullable|boolean', as: 'Notes for Finance Check')]
	public $fn_notes_update = FALSE;

	#[Rule('nullable|string|max:5000', as: 'Notes for Finance')]
	public $fn_notes;

	#[Rule('nullable|boolean', as: 'PO Check')]
	public $po_update = FALSE;

	#[Rule('nullable|string|max:35', as: 'PO')]
	public $po;

	public $single = FALSE;

	public function set($id){
		$this->single = TRUE;
		$sample = Samples::find($id);
		$this->sample_types_id   = $sample->sample_types_id;
		$this->date_expected     = $sample->date_expected?->format('Y-m-d');
		$this->date_sent         = $sample->date_sent?->format('Y-m-d');
		$this->tracking          = $sample->tracking;
		$this->weight            = $sample->weight;
		$this->sizes_id          = $sample->sizes_id;
		$this->qty               = $sample->qty;
		$this->status            = $sample->status;
		$this->comments          = $sample->comments;
		$this->do_not_charge     = $sample->do_not_charge;
		$this->do_not_charge_dev = $sample->do_not_charge_dev;
		$this->fn_notes          = $sample->fn_notes;
		$this->po                = $sample->po;
	}


	public function save($samples){
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
        $locked = FALSE;
		foreach(Samples::with('colourways.style_versions.styles.seasons')->whereIn('id', $samples)->get() as $sample){
            if(!$sample->colourways->style_versions->styles->seasons->locked){
                if($this->sample_types_id) 			$sample->sample_types_id = $this->sample_types_id;
                if($this->date_sent_update) 		$sample->date_sent = $this->date_sent;
                if($this->date_expected_update) 	$sample->date_expected = $this->date_expected;
                if($this->tracking_update) 			$sample->tracking = $this->tracking;
                if($this->weight_update) 			$sample->weight = $this->weight;
                if($this->sizes_id_update) 			$sample->sizes_id = $this->sizes_id;
                if($this->qty_update) 				$sample->qty = $this->qty;
                if($this->status_update) 			$sample->status = $this->status;
                if($this->comments_update) 			$sample->comments = $this->comments;
                if($this->do_not_charge_update) 	$sample->do_not_charge = $this->do_not_charge;
                if($this->do_not_charge_dev_update) $sample->do_not_charge_dev = $this->do_not_charge_dev;
                if($this->fn_notes_update) 			$sample->fn_notes = $this->fn_notes;
                if($this->po_update) 				$sample->po = $this->po;
                $sample->save();
            }
            else{
                $locked = TRUE;
            }
		}
		session()->flash('message', 'Sample Information Saved');
		session()->flash('alert-class', 'alert-success');
		$this->reset();
        if($locked == TRUE){
            session()->flash('message', 'One or more samples are locked and have not been updated.');
            session()->flash('alert-class', 'alert-warning');
            return "locked";
        }
        return $sample;
	}
}
