<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Design;
use App\Models\Samples;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use Illuminate\Support\Facades\Gate;

class SSEditForm extends Form
{

	#[Rule('nullable|boolean')]
	public $exfty_update;
	#[Rule('nullable|date')]
	public $exfty;


	#[Rule('nullable|boolean')]
	public $customer_exfty_update;
	#[Rule('nullable|date')]
	public $customer_exfty;


	#[Rule('nullable|boolean')]
	public $customer_into_wh_update;
	#[Rule('nullable|date')]
	public $customer_into_wh;


	#[Rule('nullable|boolean')]
	public $shipment_update;
	#[Rule('nullable|numeric|min:1')]
	public $shipment;


	#[Rule('nullable|boolean')]
	public $collection_update;
	#[Rule('nullable|date')]
	public $collection;


	#[Rule('nullable|boolean')]
	public $complete_update = false;
	#[Rule('nullable|boolean')]
	public $complete = false;

    #[Rule('nullable|boolean')]
	public $flag_issue_update = false;
	#[Rule('nullable|boolean')]
	public $flag_issue = false;


	#[Rule('nullable|boolean')]
	public $sealer_status_update;
	#[Rule('nullable|in:pending,approved,rejected')]
	public $sealer_status;


	#[Rule('nullable|boolean')]
	public $sealer_sent_update;
	#[Rule('nullable|date')]
	public $sealer_sent;


	#[Rule('nullable|boolean')]
	public $sealer_comments_update;
	#[Rule('nullable|string|max:500')]
	public $sealer_comments;


	#[Rule('nullable|boolean')]
	public $shipment_status_update;
	#[Rule('nullable|in:pending,approved,rejected')]
	public $shipment_status;


	#[Rule('nullable|boolean')]
	public $shipment_sent_update;
	#[Rule('nullable|date')]
	public $shipment_sent;


	#[Rule('nullable|boolean')]
	public $shipment_comments_update;
	#[Rule('nullable|string|max:500')]
	public $shipment_comments;


	#[Rule('nullable|boolean')]
	public $fn_notes_update;
	#[Rule('nullable|string|max:500')]
	public $fn_notes;

	public $notes_update;
	#[Rule('nullable|string|max:500')]
	public $notes;


	#[Rule('nullable|boolean')]
	public $rt_update;
	#[Rule('nullable|string|max:35')]
	public $rt;


	#[Rule('nullable|boolean')]
	public $factory_update;
	#[Rule('nullable|string|max:35')]
	public $factory;


	#[Rule('nullable|boolean')]
	public $customs_update;
	#[Rule('nullable|string|max:35')]
	public $customs;


	#[Rule('nullable|boolean')]
	public $transporter_update;
	#[Rule('nullable|string|max:35')]
	public $transporter;


	#[Rule('nullable|boolean')]
	public $finance_complete_update = false;
	#[Rule('nullable|boolean')]
	public $finance_complete = false;





	public function clear(){
		$this->reset();
	}

	public function update($drops)
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

        if(is_string($drops))
			$drops = json_decode($drops);

		foreach($drops as $drop){
			$dropUpdate = ShipmentLine::with('customer_order_lines.colourways', 'shipments')->find($drop);
            
            if (!$dropUpdate) {
                continue;
            }
            
			if($this->exfty_update){
                Gate::authorize('order:update');
				$dropUpdate->exfty = $this->exfty;
			}
			if($this->customer_exfty_update){
                Gate::authorize('order:update');
				$dropUpdate->customer_order_lines->factory_cust_date = $this->customer_exfty;
			}
			if($this->customer_into_wh_update){
                Gate::authorize('order:update');
				$dropUpdate->customer_order_lines->wh_cust_date = $this->customer_into_wh;
			}
			if($this->shipment_update){
                Gate::authorize('order:update');
				$dropUpdate->shipment_id = empty($this->shipment) ? null : $this->shipment;
			}
			if($this->collection_update){
                Gate::authorize('order:update');
				$dropUpdate->collection_date = $this->collection;
			}
			if($this->complete_update){
                Gate::authorize('order:update');
				$dropUpdate->complete = (bool) $this->complete;
			}
            if($this->flag_issue_update){
                Gate::authorize('order:update');
				$dropUpdate->flag_issue = (bool) $this->flag_issue;
			}
			if($this->fn_notes_update){
                if (!Gate::check('style:update') && !Gate::check('order:update') && !Gate::check('finance:update')) {
                    abort(403, 'Unauthorized to update finance notes.');
                }
				$dropUpdate->fn_notes = $this->fn_notes;
			}
			if($this->notes_update){
                if (!Gate::check('style:update') && !Gate::check('order:update')) {
                    abort(403, 'Unauthorized to update notes.');
                }
				$dropUpdate->notes = $this->notes;
			}
			if($this->rt_update){
                Gate::authorize('finance:update');
				$dropUpdate->rt_invoice = $this->rt;
			}
			if($this->factory_update){
                Gate::authorize('finance:update');
				$dropUpdate->factory_invoice = $this->factory;
			}
			if($this->customs_update){
                Gate::authorize('finance:update');
				$dropUpdate->customs_agency_invoice = $this->customs;
			}
			if($this->transporter_update && $dropUpdate->shipments != NULL){
                Gate::authorize('finance:update');
				$dropUpdate->shipments->transporter_invoice = $this->transporter;
			}
			if($this->finance_complete_update){
                Gate::authorize('finance:update');
				$dropUpdate->invoiced = (bool) $this->finance_complete;
			}

            if($this->sealer_status_update | $this->sealer_sent_update | $this->sealer_comments_update){
                abort_unless(Gate::any(['order:update', 'style:update']), 403);
                $sealer = Samples::where('sample_types_id', '3')->whereRelation('colourways.customer_order_lines.shipment_lines', 'id', '=', $drop)->latest()->first();
                if(!empty($sealer)){
                    if($this->sealer_status_update){
                        $sealer->status = $this->sealer_status;
                    }
                    if($this->sealer_sent_update){
                        $sealer->date_sent = $this->sealer_sent;
                    }
                    if($this->sealer_comments_update){
                        $sealer->production_comment = $this->sealer_comments;
                    }
                    $sealer->save();
                }
                else{
                    if($this->sealer_status_update){
                        $dropUpdate->sealer_status = $this->sealer_status;
                    }
                    if($this->sealer_comments_update){
                        $dropUpdate->sealer_comments = $this->sealer_sent . ' ' . $this->sealer_comments;
                    }
                }
            }

            if($this->shipment_status_update | $this->shipment_sent_update | $this->shipment_comments_update){
                abort_unless(Gate::any(['order:update', 'style:update']), 403);
                $shipment = Samples::where('sample_types_id', '7')->whereRelation('colourways.customer_order_lines.shipment_lines', 'id', '=', $drop)->latest()->first();
                // dd($shipment);
                if(!empty($shipment)){
                    if($this->shipment_status_update){
                        $shipment->status = $this->shipment_status;
                    }
                    if($this->shipment_sent_update){
                        $shipment->date_sent = $this->shipment_sent;
                    }
                    if($this->shipment_comments_update){
                        $shipment->production_comment = $this->shipment_comments;
                    }
                    $shipment->save();
                }
                else{
                    if($this->shipment_status_update){
                        $dropUpdate->shipment_status = $this->shipment_status;
                    }
                    if($this->shipment_comments_update){
                        $dropUpdate->shipment_comments = $this->shipment_sent . ' ' . $this->shipment_comments;
                    }
                }
            }

            $dropUpdate->save();
			$dropUpdate->customer_order_lines->save();
			if($dropUpdate->shipments != NULL)
				$dropUpdate->shipments->save();
		}
		session()->flash('message', 'Saved!');
		session()->flash('alert-class', 'alert-success');
	}
}
