<?php

namespace App\Livewire\Forms;

use Exception;
use Throwable;
use Livewire\Form;
use App\Models\Price;
use App\Models\Sizes;
use App\Helper\Functions;
use Livewire\Attributes\On;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrders;
use App\Models\ShipmentLineSizes;
use Livewire\Attributes\Computed;
use App\Models\CustomerOrderFiles;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Storage;
use App\Models\CustomerOrderLineQuantities;
use Illuminate\Validation\ValidationException;

class OrdersEditQuickAddForm extends Form
{
	public $order, $orderLinesEdit = [], $sizesOpened =[], $sizes = [], $qtys = [], $dates = [], $prices = [];

	public function rules()
    {
        return [
            'dates.exfty' => 'required|date', // Ensure Exfty date is required, a valid date
            'dates.factory_cust_date' => 'nullable|date',
            'dates.wh_cust_date' => 'nullable|date',
            'dates.start_knit' => 'nullable|date',
            'qtys.*.ordered.*' => 'nullable|numeric|min:0', // Allow empty quantity but restrict negative values
            'qtys.*.shipped.*' => 'nullable|numeric|min:0', // Allow empty quantity but restrict negative values
            'sizes.*' => 'nullable|string|max:10', // Limit size name length
        ];
    }

	public function open($order = NULL){
        $order = CustomerOrders::
            with(
                [
                    'customer_order_lines:id,customer_orders_id,colourways_id,factory_cust_date,wh_cust_date,start_knit' => [
                        'colourways:id,name,style_versions_id' => [
                            'style_versions:id,name,styles_id' => [
                                'styles:id,customer_ref,designs_id' => [
                                    'designs:id,description'
                                ]
                            ]
                        ],
                        'customer_order_line_quantities' => [
                            'sizes'
                        ],
                        'shipment_lines:id,customer_order_lines_id,exfty'
                    ],
                    'customers:id,settings,currency,default_commission,default_discount'
                ])
            ->find($order);

        $this->sizes = [];
        $this->qtys = [];

        $this->order = $order;

        // dd($this->order);


        if($order->customer_order_lines){
            foreach($order->customer_order_lines as $l=>$line){
                foreach($line->customer_order_line_quantities as $s=>$size){
                    $this->sizes[$size->sizes->id] = $size->sizes->name;
                }
            }

            $this->sizes = array_values($this->sizes);

            foreach($order->customer_order_lines as $l=>$line){
                foreach($line->customer_order_line_quantities as $s=>$size){
                    $this->qtys[$line->id][array_search($size->sizes->name, $this->sizes)]['ordered'] = $size->qty;
                    $this->qtys[$line->id][array_search($size->sizes->name, $this->sizes)]['shipped'] = $line->shipment_lines->first()?->shipment_line_sizes->where('sizes_id', $size->sizes->id)->first()->shipped_qty ?? NULL;
                }
                if($this->order->order_type == "commission"){
                    $this->prices[$line->id]['price'] = $size->price ?? NULL;
                    $this->prices[$line->id]['commission'] = $size->commission ?? $this->order->customers->default_commission;
                    $this->prices[$line->id]['discount'] = $size->discount ?? $this->order->customers->default_discount;
                }

            }


            $datesToCheck = [
                'exfty' => fn($line) => $line->shipment_lines->pluck('exfty'),
                'factory_cust_date' => fn($line) => collect([$line->factory_cust_date]),
                'wh_cust_date' => fn($line) => collect([$line->wh_cust_date]),
                'start_knit' => fn($line) => collect([$line->start_knit]),
            ];

            foreach ($datesToCheck as $key => $extractor) {
                $dates = collect($order->customer_order_lines)
                    ->flatMap($extractor)
                    ->filter()
                    ->unique();

                if ($dates->count() === 1) {
                    $this->dates[$key] = $dates->first()?->format('Y-m-d');
                }
            }

            // dd($this->dates['exfty']->format('d-m-y'));
            $this->orderLinesEdit = $order->customer_order_lines->toArray();

		}
        // dd($this->sizes);
	}

    public function removeItem($item){
        unset($this->qtys[$item]);
        unset($this->orderLinesEdit[$item]);
    }

    public function restoreItem($item){
        $this->save();
        $this->open($this->order);
    }

    public function readOnly(){
        return $this->order->seasons->locked;
    }

    public function save()
    {
        $this->validate();
        // if(Gate::check('asmin')){
        //     dd($this->dates['exfty']);
        // }

        abort_unless(!$this->readOnly(), 403);


        $this->updateOrderLineQuantities();
        $this->updateOrderLineDates();

        session()->flash('message', 'Dates & Item Lines Saved');
        session()->flash('alert-class', 'alert-success');
        try {

        } catch (ValidationException $e) {
            session()->flash('message', 'Please fix the following errors:');
            session()->flash('errors', $e->errors());
            session()->flash('alert-class', 'alert-danger');
        } catch (Exception $e) {  // Catch more general exceptions
            session()->flash('message', 'An error occurred: ' . $e->getMessage());
            session()->flash('alert-class', 'alert-danger');
        }
    }

    private function updateOrderLineDates()
    {
        foreach ($this->orderLinesEdit as $l => $line) {
            $lineModel = CustomerOrderLines::find($line['id']);

            if (!$lineModel) {
                throw new Exception("Order line with ID {$line['id']} not found");
            }
            if ($this->dates['exfty'] ?? null) {
                $lineModel->shipment_lines->first()?->update(['exfty' => $this->dates['exfty']]);
            }
            if($this->dates['factory_cust_date'] ?? NULL){
                $lineModel->update(['factory_cust_date' => $this->dates['factory_cust_date']]);
            }
            if($this->dates['wh_cust_date'] ?? NULL){
                $lineModel->update(['wh_cust_date' => $this->dates['wh_cust_date']]);
            }
            if($this->dates['start_knit'] ?? NULL){
                $lineModel->update(['start_knit' => $this->dates['start_knit']]);
            }
        }
    }

    public function removeSize($s){
        unset($this->sizes[$s]);
        foreach($this->qtys as $q=>$qty){
            unset($this->qtys[$q][$s]);
        }
    }
    public function addSize(){
        $this->sizes[] = [];
    }

    public function addCustSizes(){
        $sizes = Sizes::whereIn('id', $this->order->customers->setting('size-defaults'))->get();

        $sizes_array = [];
        foreach($sizes as $i=>$s){
            $sizes_array[] = $s->name;
        }
        $this->sizes = $sizes_array;
    }

    private function updateOrderLineQuantities()
    {
        foreach ($this->qtys as $l=>$line) {
            $lineModel = CustomerOrderLines::find($l);

            if (!$lineModel) {
                throw new Exception("Order line with ID {$l} not found");
            }

            $qtys = [];
            foreach ($line as $q => $qty) {
                if ($qty && isset($qty['ordered'])) {
                    $quantity = new CustomerOrderLineQuantities;
                    $quantity->sizes_id = Sizes::firstOrCreate(['name' => $this->sizes[$q]])->id;

                    $quantity->qty = $qty['ordered'];

                    if($this->order->order_type == "commission"){
                        // dd($line, $l, $this->qtys);
                        $quantity->price = $this->prices[$l]['price'] ?? 0;
                        $quantity->commission = $this->prices[$l]['commission'] ?? 0;
                        $quantity->discount = $this->prices[$l]['discount'] ?? 0;
                    }

                    $qtys[] = $quantity;

                    //ADD PRICING CACHE HERE
                }
            }
            $lineModel->customer_order_line_quantities()->forceDelete();
            $lineModel->customer_order_line_quantities()->saveMany($qtys);
            
            // Warm up price resolutions for all sizes in this colourway
            // This ensures the shipment schedule can find prices via SQL join
            $priceResolutionService = app(\App\Services\PriceResolutionService::class);
            $priceResolutionService->warmupColourway($lineModel->colourways_id);

            if(count($lineModel->shipment_lines) < 2){
                $line = ShipmentLine::firstOrCreate([
                    'customer_order_lines_id' => $lineModel->id,
                ]);

                // dd($line->shipment_line_sizes);

                $qtys = [];
                foreach($this->qtys[$l] as $q=>$qty){
                    if($qty && (isset($qty['ordered']) || isset($qty['shipped']))){
                        $quantity = new ShipmentLineSizes;
                        $quantity->sizes_id = Sizes::firstOrCreate(['name' => $this->sizes[$q]])->id;
                        $quantity->qty = $qty['ordered'] ?? 0;
                        if(!empty($qty['shipped']))
                            $quantity->shipped_qty = $qty['shipped'] ?? 0;

                        $qtys[] = $quantity;
                    }
                }
                // dd($qtys);
                // dd($qtys);
                $line->shipment_line_sizes()->forceDelete();
                $line->shipment_line_sizes()->saveMany($qtys);
            }
        }
    }
}
