<?php

namespace App\Livewire\Forms;

use Exception;
use Throwable;
use Livewire\Form;
use App\Models\Price;
use App\Models\Sizes;
use App\Helper\Functions;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrders;
use App\Models\ShipmentLineSizes;
use App\Models\CustomerOrderFiles;
use App\Models\CustomerOrderLines;
use Illuminate\Support\Facades\Storage;
use App\Models\CustomerOrderLineQuantities;

class OrdersEditFormDev extends Form
{
	public ?CustomerOrders $order;

	public $orderEdit, $uploadFiles = [], $removeItems = [], $removeDrops = [], $removeSizes = [], $new = FALSE, $sizes;

	public function rules()
    {
        return [
			'orderEdit.department_id' => 'required_if:new,1|numeric|min:1',
			'orderEdit.seasons_id' => 'required|numeric|min:1',
			'orderEdit.customers_id' => 'required|numeric|min:1',
			'orderEdit.incoterms' => 'required|in:EXW,FCA,CPT,CIP,DAP,DPU,DDP,FAS,FOB,CFR,CIF',
			'orderEdit.customer_addresses_id' => 'nullable|numeric|min:1',
			'orderEdit.customer_po' => 'required|string|max:35',
			'orderEdit.asn' => 'nullable|string|max:35',
			'orderEdit.cust_ship_no' => 'nullable|string|max:35',
			'orderEdit.order_date' => 'nullable|date',
			'orderEdit.sent_to_factory' => 'nullable|date',
			'orderEdit.incomplete_flag' => 'required|boolean',
			'orderEdit.shipment_mode' => 'nullable|string|max:35',
			'orderEdit.phase_id' => 'nullable|numeric|min:1',
        ];
    }

	public function open($order = NULL, $commission = FALSE){
        $this->sizes = Sizes::all();

		if(!empty($order)){
			$this->order = $order;
			// Minimize form state to only top-level fields used in header
			$this->orderEdit = [
				'departments_id' => $order->departments_id,
				'seasons_id' => $order->seasons_id,
				'customers_id' => $order->customers_id,
				'incoterms' => $order->incoterms,
				'customer_addresses_id' => $order->customer_addresses_id,
				'customer_po' => $order->customer_po,
				'cust_ship_no' => $order->cust_ship_no,
				'order_date' => $order->order_date,
				'sent_to_factory' => $order->sent_to_factory,
				'incomplete_flag' => $order->incomplete_flag,
				'order_type' => $order->order_type,
				'cancelled' => $order->cancelled,
				'shipment_mode' => $order->shipment_mode,
				'phase_id' => $order->phase_id,
			];
		}
		else{
			$this->order = null;
			$this->orderEdit = [];
            if($commission)
                $this->orderEdit['order_type'] = 'commission';
			$this->orderEdit['incomplete_flag'] = 0;
			$this->orderEdit['cancelled'] = 0;
		}
	}

    public function close(){
        $this->reset('sizes', 'uploadFiles', 'removeItems', 'removeDrops', 'removeSizes', 'new', 'order');
        $this->orderEdit = [];
    }


	public function save(){
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving - check size qtys are filled in');
		session()->flash('alert-class', 'alert-danger');

        abort_unless(!$this->order->seasons->locked, 403);

		if(!empty($this->order)){
			$order = $this->order;
            $newOrderFlag = FALSE;
		}
		else{
			$order = new CustomerOrders;
            $newOrderFlag = TRUE;
		}
		$order->departments_id        = $this->orderEdit['departments_id'];
		$order->seasons_id            = $this->orderEdit['seasons_id'];
		$order->customers_id          = $this->orderEdit['customers_id'];
		$order->incoterms             = $this->orderEdit['incoterms'];
		$order->customer_addresses_id = $this->orderEdit['customer_addresses_id'] ?? NULL;
		$order->customer_po           = $this->orderEdit['customer_po'] ?? NULL;
		$order->cust_ship_no          = $this->orderEdit['cust_ship_no'] ?? NULL;
		$order->order_date            = $this->orderEdit['order_date'] ?? NULL;
		$order->sent_to_factory       = $this->orderEdit['sent_to_factory'] ?? NULL;
		$order->incomplete_flag       = $this->orderEdit['incomplete_flag'];
		$order->order_type            = $this->orderEdit['order_type'] ?? "wholesale";
		$order->cancelled             = $this->orderEdit['cancelled'];
		$order->shipment_mode         = $this->orderEdit['shipment_mode'];
		$order->phase_id              = $this->orderEdit['phase_id'] ?? NULL;
		$order->save();

        try {

            if($this->uploadFiles != []){
                foreach($this->uploadFiles as $file){
                    $path = NULL;
                    $entry = new CustomerOrderFiles();
                    $path = Storage::disk('public')->put('customerOrderFiles', $file);
                    if($path != NULL){
                        $entry->customer_orders_id = $order->id;
                        $entry->filename = $file->getClientOriginalName();
                        $entry->file = $path;
                        $entry->save();
                    }
                }
            }
            session()->flash('message', 'Style Information Saved');
            session()->flash('alert-class', 'alert-success');
            return true;
        } catch (Throwable $e) {
            if($newOrderFlag)
                $order->delete();
            report($e);

            return false;
        }
	}
}
