<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\ShipmentLine;
use Livewire\Attributes\Rule;
use App\Models\ShipmentLineSizes;
use App\Models\CustomerOrderLines;
use App\Models\CustomerOrderLineQuantities;

class OrdersEditColourwaysQuantitiesForm extends Form
{
	public $ordered = [];
	public $drops = [];

	public $line;


	public function rules()
    {
        return [
			'ordered.*.customer_order_lines_id' => 'required|numeric|min:1',
			'ordered.*.sizes_id'                => 'required|numeric|min:1',
			'ordered.*.qty'                     => 'required|numeric|min:0',
			'ordered.*.SKU'                     => 'nullable|string|max:35',
			'ordered.*.barcode'                 => 'nullable|string|max:35',
			'drops.*.sizes.*.qty'             => 'nullable|numeric|min:0',
			'drops.*.sizes.*.shipped_qty'     => 'nullable|numeric|min:0',
			'drops.*.exfty'                   => 'required|date',
        ];
    }

    public function open($line){
		$this->line = CustomerOrderLines::with('customer_order_line_quantities', 'shipment_lines.shipment_line_sizes')->find($line);
		if(empty($line)){

		}
		else{
			foreach($this->line->customer_order_line_quantities as $size){
				$this->ordered[] = [
					'customer_order_lines_id' => $size->customer_order_lines_id,
					'sizes_id'                => $size->sizes_id,
					'sizes'                   => $size->sizes->name,
					'qty'                     => $size->qty,
					'SKU'                     => $size->SKU,
					'barcode'                 => $size->barcode,
				];
			}
			foreach($this->line->shipment_lines ?? [] as $d=>$drop){
				$this->drops[$d]['id'] = $drop->id;
				$this->drops[$d]['exfty'] = $drop->exfty;
				foreach($this->ordered as $s=>$size){
					$this->drops[$d]['sizes'][$s] = [
						'sizes_id' => $size['sizes_id'],
						'qty' => $drop->shipment_line_sizes->where('sizes_id', $size['sizes_id'])->first()?->qty,
						'shipped_qty' => $drop->shipment_line_sizes->where('sizes_id', $size['sizes_id'])->first()?->shipped_qty,
					];
				}
			}
		}

	}

	public function save(){
		// dd($this);
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		// dd($this);
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');
	
		if(empty($this->line)){
			throw new \Exception("Line data is missing");
		}
		

		$sizes = [];
		foreach($this->ordered as $size){
			$newSize = new CustomerOrderLineQuantities;
			$newSize->sizes_id = $size['sizes_id'];
			$newSize->qty = $size['qty'];
			$newSize->SKU = $size['SKU'];
			$newSize->barcode = $size['barcode'];
			$sizes[] = $newSize;
		}



		$this->line->customer_order_line_quantities()->delete();
		$this->line->customer_order_line_quantities()->saveMany($sizes);
		
		// Warm up price resolutions for all sizes in this colourway
		// This ensures the shipment schedule can find prices via SQL join
		$priceResolutionService = app(\App\Services\PriceResolutionService::class);
		$priceResolutionService->warmupColourway($this->line->colourways_id);

		$this->line->load('shipment_lines');

		// Prevent duplicate EXFTY dates per line
		$exftyDates = array_filter(array_column($this->drops ?? [], 'exfty'));
		$duplicates = array_diff_assoc($exftyDates, array_unique($exftyDates));
		if (!empty($duplicates)) {
			throw new \Exception("Duplicate EXFTY dates found. Each drop must have a unique EXFTY.");
		}

		foreach($this->drops as $d=>$drop){
			// Use stable keys to avoid creating duplicate drops
			if(!empty($drop['id'])){
				$newDrop = ShipmentLine::updateOrCreate(
					['id' => $drop['id']],
					[
						'customer_order_lines_id' => $this->line->id,
						'exfty' => $drop['exfty'] ?? NULL,
					]
				);
			}
			else{
				// If only one drop, key only by line id; otherwise key by (line id, exfty)
				if(count($this->drops) <= 1){
					$newDrop = ShipmentLine::updateOrCreate(
						['customer_order_lines_id' => $this->line->id],
						[
							'exfty' => $drop['exfty'] ?? NULL,
						]
					);
				}
				else{
					$newDrop = ShipmentLine::updateOrCreate(
						[
							'customer_order_lines_id' => $this->line->id,
							'exfty' => $drop['exfty'] ?? NULL,
						],
						[
							'customer_order_lines_id' => $this->line->id,
							'exfty' => $drop['exfty'] ?? NULL,
						]
					);
				}
			}

			$sizes = [];
			foreach($drop['sizes'] ?? [] as $s=>$size){
				$newSize              = new ShipmentLineSizes;
				$newSize->sizes_id    = $this->ordered[$s]['sizes_id'];
				$newSize->qty         = $size['qty'] ?? 0;
				$newSize->shipped_qty = $size['shipped_qty'] ?? 0;
				if(count($this->drops) <= 1){
					$newSize->qty             = $this->ordered[$s]['qty'] ?? 0;
					$this->drops[$d]['sizes'][$s]['qty'] = $this->ordered[$s]['qty'] ?? 0;
				}
				$sizes[] = $newSize;
			}

			$newDrop->shipment_line_sizes()->delete();
			$newDrop->shipment_line_sizes()->saveMany($sizes);
		}

		session()->flash('message', 'Quantity Information Saved');
		session()->flash('alert-class', 'alert-success');
	}
}
