<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use Livewire\Attributes\Rule;
use App\Models\CustomerOrderLines;

class OrdersEditColourwaysForm extends Form
{
	public $orderLinesOrigional;

	public $orderLines = [];
	public $order;

	public function rules()
    {
        return [

			'orderLines.*.customer_orders_id'       => 'required|numeric|min:1',
			'orderLines.*.colourways_id'            => 'required|numeric|min:1',
			'orderLines.*.location'                 => 'nullable|string|max:35',
			'orderLines.*.notes'                    => 'nullable|string|max:5000',
			'orderLines.*.actual_ship_date'         => 'nullable|date',
			'orderLines.*.factory_cust_date'        => 'nullable|date',
			'orderLines.*.wh_cust_date'             => 'nullable|date',
			'orderLines.*.cp_notes'                 => 'nullable|string|max:5000',
			'orderLines.*.colour_approved_date'     => 'nullable|date',
			'orderLines.*.lab_dips_sent_date'       => 'nullable|date',
			'orderLines.*.colour_approval_comments' => 'nullable|string|max:35',
			'orderLines.*.start_knit'               => 'nullable|date',

        ];
    }

	public function open($order){
		$this->reset();
		$this->order = $order;
		if(!empty($order)){
			$this->orderLinesOrigional = CustomerOrderLines::with([
				'colourways:id,name,style_versions_id' => [
					'style_versions:id,name,styles_id' => [
						'styles:id,customer_ref,designs_id',
					]
				],
			])->where('customer_orders_id', $order)->get();
			foreach($this->orderLinesOrigional as $line){
				$this->orderLines[] = [
					'id'                       => $line->id,
					'customer_orders_id'       => $line->customer_orders_id,
					'colourways_id'            => $line->colourways_id,
					'location'                 => $line->location,
					'notes'                    => $line->notes,
					'actual_ship_date'         => $line->actual_ship_date?->format('Y-m-d'),
					'factory_cust_date'        => $line->factory_cust_date?->format('Y-m-d'),
					'cp_notes'                 => $line->cp_notes,
					'colour_approved_date'     => $line->colour_approved_date?->format('Y-m-d'),
					'lab_dips_sent_date'       => $line->lab_dips_sent_date?->format('Y-m-d'),
					'colour_approval_comments' => $line->colour_approval_comments,
					'wh_cust_date'             => $line->wh_cust_date?->format('Y-m-d'),
					'start_knit'               => $line->start_knit?->format('Y-m-d'),
				];
			}
		}
	}

	// public function addItem($colourway){
	// 	$this->orderLines[] = [
	// 		'id'                       => NULL,
	// 		'customer_orders_id'       => $this->order,
	// 		'colourways_id'            => $colourway,
	// 	];
	// }

	public function save(){
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');

		foreach($this->orderLines as $l=>$line){
			if(empty($line['id'])){
				//SHOULDNT HAPPEN?
			}
			else{
				$this->orderLinesOrigional[$l]->update([
					'id'                       => $line['id'],
					'customer_orders_id'       => $line['customer_orders_id'],
					'colourways_id'            => $line['colourways_id'],
					'location'                 => $line['location'] ?? NULL,
					'notes'                    => $line['notes'] ?? NULL,
					'actual_ship_date'         => $line['actual_ship_date'] ?? NULL,
					'factory_cust_date'        => $line['factory_cust_date'] ?? NULL,
					'cp_notes'                 => $line['cp_notes'] ?? NULL,
					'colour_approved_date'     => $line['colour_approved_date'] ?? NULL,
					'lab_dips_sent_date'       => $line['lab_dips_sent_date'] ?? NULL,
					'colour_approval_comments' => $line['colour_approval_comments'] ?? NULL,
					'wh_cust_date'             => $line['wh_cust_date'] ?? NULL,
					'start_knit'               => $line['start_knit'] ?? NULL,
				]);
			}
		}

		session()->flash('message', 'Item Information Saved');
		session()->flash('alert-class', 'alert-success');
	}
}
