<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Price;
use App\Models\Design;
use App\Models\Samples;
use App\Models\ShipmentLine;
use App\Models\StyleVersions;
use Livewire\Attributes\Rule;

class FinanceSamplesForm extends Form
{

	public $samples;


	public function rules()
    {
        return [

			'samples.*.rt_invoice'       => 'nullable|string|max:35',
			'samples.*.fty_invoice'      => 'nullable|string|max:35',
			'samples.*.finance_comments' => 'nullable|string|max:100',
			'samples.*.fn_complete'      => 'nullable|boolean',

        ];
    }


	public function clear(){
		$this->reset();
	}

	public function set($samples){
		$this->samples = $samples->toArray()['data'];
	}



	public function update($val, $var)
	{
		$this->validate();
		
		$s = explode('.', $var)[1];
		$var = explode('.', $var)[2];
		
		// dd($this->samples[$s]);
		
		$sample = Samples::find($this->samples[$s]['id']);
        // dd($this->samples[$s]['id'], $sample);
		switch ($var){
			case 'fn_complete':
				$sample->update([$var => empty($val) ? 0 : $val]);
				break;
			default:
				$sample->update([$var => empty($val) ? NULL : $val]);
			}
	}
}
