<?php

namespace App\Livewire\Forms;

use Livewire\Form;
use App\Models\Design;
use App\Models\Styles;
use App\Models\Colourways;
use App\Models\StyleVersions;
use Livewire\Attributes\Rule;
use App\Models\ColourwayYarns;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Storage;

class EditColourwaysForm extends Form
{
	public $svOrigional;
	public $svEdit;

    public $yarnPriceAll;
    public $yarnPriceAllType;

	public function rules()
    {
        return [
			'yarnPriceAll' => 'nullable|numeric',
			'yarnPriceAllType' => 'nullable|in:solid,melange,mixed',
			'svEdit.colourways.*.colourway_yarns.*.percentage' => 'nullable|numeric',
			'svEdit.colourways.*.colourway_yarns.*.price' => 'nullable|numeric',
			'svEdit.colourways.*.colourway_yarns.*.not_full_factored' => 'nullable|boolean',
		];
	}

	public function clear(){
		$this->reset();
	}

	public function set($sv)
	{
		$this->svOrigional = StyleVersions::with('colourways.colourway_yarns.yarn_colours.yarn.suppliers')->find($sv);
		$this->svEdit = $this->svOrigional->toArray();
	}

    public function changeAllYarnPrices(){
        foreach($this->svEdit['colourways'] ?? [] as $c=>$colourway){
            foreach($colourway['colourway_yarns'] ?? [] as $cy=>$colourway_yarn){
                if (!$this->yarnPriceAllType || $this->yarnPriceAllType == $colourway['colour_type']) {
                    $this->svEdit['colourways'][$c]['colourway_yarns'][$cy]['price'] = $this->yarnPriceAll;
                }
            }
        }
    }

	public function update()
	{
		session()->flash('message', 'Validation Error');
		session()->flash('alert-class', 'alert-warning');
		$this->validate();
		session()->flash('message', 'Error Saving');
		session()->flash('alert-class', 'alert-danger');



			foreach($this->svEdit['colourways'] ?? [] as $c=>$colourway){
                $colourwaySaved = $this->svOrigional->colourways->where('id', $colourway['id'])->first();

				$cyarnIds = collect($colourway['colourway_yarns'] ?? [])->pluck('id')->toArray();
				foreach($colourwaySaved->load('colourway_yarns')->colourway_yarns as $DBcy){
					if(!in_array($DBcy->id, $cyarnIds)){
						$DBcy->delete();
					}
				}
				foreach($colourway['colourway_yarns'] ?? [] as $cy=>$colourway_yarn){
					ColourwayYarns::updateOrCreate(
						[
							'id' => $colourway_yarn['id']
						],
						[
							"percentage" => $colourway_yarn['percentage'] ?? 0,
							"price" => $colourway_yarn['price'] ?? 0,
							"not_full_factored" => $colourway_yarn['not_full_factored'] ?? FALSE,
						]
					);
				}



			}



		session()->flash('message', 'Style Information Saved');
		session()->flash('alert-class', 'alert-success');
	}


}
